/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.ems;

import hr.tis.ems.Concatenation;
import hr.tis.ems.EMSOutputStream;
import hr.tis.ems.PortNumbers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SAR {
    private SAR() {
    }

    public static List split(byte[] data, int sourcePort, int destPort) {
        int count = 1;
        if (data.length > 133) {
            count = data.length / 128 + 1;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(count);
        PortNumbers pp = new PortNumbers(sourcePort, destPort);
        try {
            if (count > 1) {
                Concatenation cc = new Concatenation();
                cc.generateRandomRef();
                cc.setMax(count);
                EMSOutputStream header = new EMSOutputStream();
                for (int i = 0; i < count; ++i) {
                    cc.setSeq(i + 1);
                    header.write(pp);
                    header.write(cc);
                    byte[] ba = i < count - 1 ? new byte[140] : new byte[data.length % 128 + 12];
                    System.arraycopy(header.toByteArray(), 0, ba, 0, 12);
                    System.arraycopy(data, i * 128, ba, 12, ba.length - 12);
                    result.add(ba);
                    header.reset();
                }
            } else {
                EMSOutputStream header = new EMSOutputStream();
                header.write(pp);
                byte[] ba = new byte[data.length + 7];
                System.arraycopy(header.toByteArray(), 0, ba, 0, 7);
                System.arraycopy(data, 0, ba, 7, data.length);
                result.add(ba);
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return result;
    }
}

