/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client;

import hr.tis.mgw.client.location.Accuracy;
import hr.tis.mgw.client.location.Location;
import hr.tis.mgw.client.message.DeliveryStatusInfo;
import hr.tis.mgw.client.message.Format;
import hr.tis.mgw.client.message.Priority;
import hr.tis.mgw.client.message.Status;
import org.apache.axis.types.URI;
import org.csapi.www.schema.parlayx.common.v1_0.EndUserIdentifier;
import org.csapi.www.schema.parlayx.mm.v1_0.MessagePriority;
import org.csapi.www.schema.parlayx.sms.v1_0.DeliveryStatus;
import org.csapi.www.schema.parlayx.sms.v1_0.DeliveryStatusType;
import org.csapi.www.schema.parlayx.sms.v1_0.SmsFormat;
import org.csapi.www.schema.parlayx.terminal_location.v1_0.LocationAccuracy;
import org.csapi.www.schema.parlayx.terminal_location.v1_0.LocationInfo;

public class ParlayXConverter {
    private static final String NULL_URI = "null://null";
    private static final String NULL_SCHEME = "null";
    private static final String TEL_SCHEME = "tel:";

    private ParlayXConverter() {
    }

    public static EndUserIdentifier toEndUserIdentifier(String string) throws URI.MalformedURIException {
        String string2 = string != null ? (string.indexOf(58) == -1 ? TEL_SCHEME + string : string) : NULL_URI;
        URI uRI = new URI(string2);
        return new EndUserIdentifier(uRI);
    }

    public static EndUserIdentifier[] toEndUserIdentifiers(String[] stringArray) throws URI.MalformedURIException {
        EndUserIdentifier[] endUserIdentifierArray = new EndUserIdentifier[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            endUserIdentifierArray[i] = ParlayXConverter.toEndUserIdentifier(stringArray[i]);
        }
        return endUserIdentifierArray;
    }

    public static String fromEndUserIdentifier(EndUserIdentifier endUserIdentifier) {
        String string = endUserIdentifier.getValue().getScheme();
        String string2 = endUserIdentifier.getValue().getPath();
        if (string == null || NULL_SCHEME.equalsIgnoreCase(string)) {
            return null;
        }
        return string2;
    }

    public static String[] fromEndUserIdentifiers(EndUserIdentifier[] endUserIdentifierArray) {
        String[] stringArray = new String[endUserIdentifierArray.length];
        for (int i = 0; i < endUserIdentifierArray.length; ++i) {
            stringArray[i] = ParlayXConverter.fromEndUserIdentifier(endUserIdentifierArray[i]);
        }
        return stringArray;
    }

    public static MessagePriority toParlayXMessagePriority(Priority priority) {
        return priority != null ? MessagePriority.fromValue(priority.getValue()) : MessagePriority.Low;
    }

    public static Priority fromParlayXMessagePriority(MessagePriority messagePriority) {
        return messagePriority != null ? Priority.fromValue(messagePriority.getValue()) : Priority.LOW;
    }

    public static SmsFormat toParlayXSmsFormat(Format format) {
        return SmsFormat.fromValue(format.getValue());
    }

    public static Status fromParlayXDeliveryStatus(DeliveryStatus deliveryStatus) {
        return Status.fromValue(deliveryStatus.getValue());
    }

    public static Status fromParlayXDeliveryStatus(org.csapi.www.schema.parlayx.mm.v1_0.DeliveryStatus deliveryStatus) {
        return Status.fromValue(deliveryStatus.getValue());
    }

    public static DeliveryStatusInfo[] fromParlayXDeliveryStatusTypes(DeliveryStatusType[] deliveryStatusTypeArray) {
        DeliveryStatusInfo[] deliveryStatusInfoArray = new DeliveryStatusInfo[deliveryStatusTypeArray.length];
        for (int i = 0; i < deliveryStatusTypeArray.length; ++i) {
            deliveryStatusInfoArray[i] = new DeliveryStatusInfo(ParlayXConverter.fromEndUserIdentifier(deliveryStatusTypeArray[i].getDestinationAddress()), ParlayXConverter.fromParlayXDeliveryStatus(deliveryStatusTypeArray[i].getDeliveryStatus()));
        }
        return deliveryStatusInfoArray;
    }

    public static DeliveryStatusInfo[] fromParlayXDeliveryStatusTypes(org.csapi.www.schema.parlayx.mm.v1_0.DeliveryStatusType[] deliveryStatusTypeArray) {
        DeliveryStatusInfo[] deliveryStatusInfoArray = new DeliveryStatusInfo[deliveryStatusTypeArray.length];
        for (int i = 0; i < deliveryStatusTypeArray.length; ++i) {
            deliveryStatusInfoArray[i] = new DeliveryStatusInfo(ParlayXConverter.fromEndUserIdentifier(deliveryStatusTypeArray[i].getDestinationAddress()), ParlayXConverter.fromParlayXDeliveryStatus(deliveryStatusTypeArray[i].getDeliveryStatus()));
        }
        return deliveryStatusInfoArray;
    }

    public static LocationAccuracy toParlayXLocationAccuracy(Accuracy accuracy) {
        return LocationAccuracy.fromValue(accuracy.getValue());
    }

    public static Accuracy fromParlayXLocationAccuracy(LocationAccuracy locationAccuracy) {
        return Accuracy.fromValue(locationAccuracy.getValue());
    }

    public static Location fromParlayXLocationInfo(LocationInfo locationInfo) {
        return new Location(locationInfo.getLongitude(), locationInfo.getLatitude(), ParlayXConverter.fromParlayXLocationAccuracy(locationInfo.getAccuracy()), locationInfo.getDateTime().getTime());
    }
}

