/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis.AxisProperties;
import org.apache.axis.client.Stub;

public abstract class AbstractManager2 {
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final boolean DEFAULT_THREADED_LISTENER = true;
    private static final String OPTIONAL_STRING_VALUE = "";
    private static final String COMMONS_HTTPCLIENT_AUTHENTICATION_PREEMPTIVE_KEY = "httpclient.authentication.preemptive";
    private static final String COMMONS_HTTPCLIENT_AUTHENTICATION_PREEMPTIVE_VALUE = "true";
    protected int timeout = 30000;
    protected boolean threadedListener = true;
    protected String serverURL;
    protected String username;
    protected String password;
    protected Map listeners = new HashMap();

    protected void applyCredentialsToStub(String string, String string2, Stub stub) {
        stub.setUsername(string);
        stub.setPassword(string2);
    }

    protected void applyTimeoutToStub(Stub stub) {
        stub.setTimeout(this.timeout);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public boolean isThreadedListener() {
        return this.threadedListener;
    }

    public void setThreadedListener(boolean bl) {
        this.threadedListener = bl;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("ServerURL can't be null or empty.");
        }
        if (!string.endsWith("/")) {
            string = string.concat("/");
        }
        this.serverURL = string;
        this.initPortsURLs();
    }

    protected abstract void initPortsURLs();

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Password must be set but is null.");
        }
        this.password = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Username must be set but is null.");
        }
        this.username = string;
    }

    protected void runListener(Runnable runnable) {
        if (this.isThreadedListener()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    protected void validateOriginatorAddresses(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Originator Address must be set but is null or empty.");
        }
    }

    protected void validateDestinationAddresses(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Destination Addresses must be set and have at least one value but are null or empty.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].trim().length() != 0) continue;
            throw new IllegalArgumentException("Destination Address must be set but is null or empty.");
        }
    }

    protected void validateCredentials(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Username must be set but is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Password must be set but is null.");
        }
    }

    protected String optional(String string) {
        return string != null ? string : OPTIONAL_STRING_VALUE;
    }

    protected void initializeAxis() {
        this.configureAxisProperties();
        this.initAxisServices();
    }

    protected void configureAxisProperties() {
        AxisProperties.setProperty((String)"axis.http.client.maximum.total.connections", (String)"10");
        AxisProperties.setProperty((String)"axis.http.client.maximum.connections.per.host", (String)"10");
        AxisProperties.setProperty((String)"axis.http.client.connection.pool.timeout", (String)"0");
        AxisProperties.setProperty((String)"axis.http.client.connection.default.connection.timeout", (String)"0");
        AxisProperties.setProperty((String)"axis.http.client.connection.default.so.timeout", (String)"0");
        System.setProperty(COMMONS_HTTPCLIENT_AUTHENTICATION_PREEMPTIVE_KEY, COMMONS_HTTPCLIENT_AUTHENTICATION_PREEMPTIVE_VALUE);
    }

    protected abstract void initAxisServices();
}

