/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.message;

import java.io.UnsupportedEncodingException;

public class MmsPart {
    private static final int PREVIEW_LENGTH = 32;
    private static final String PREVIEW_TEXT_ERROR = " -- UNABLE TO COVERT TO STRING -- ";
    private static final String TEXT_ENCODING = "utf-8";
    private static final String TEXT_CONTENT_TYPE = "text/plain";
    private byte[] bytes;
    private String contentType;
    private String contentId;
    private String contentLocation;
    private String toString;

    public MmsPart(String string) {
        this(string, null, null);
    }

    public MmsPart(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("Text must be set and can't be null.");
        }
        try {
            this.bytes = string.getBytes(TEXT_ENCODING);
            this.contentType = TEXT_CONTENT_TYPE;
            this.contentId = string2;
            this.contentLocation = string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 encoding not supported.");
        }
    }

    public MmsPart(byte[] byArray, String string) {
        this(byArray, string, null, null);
    }

    public MmsPart(byte[] byArray, String string, String string2, String string3) {
        if (byArray == null) {
            throw new IllegalArgumentException("Binary content must be set and can't be null.");
        }
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Content Type must be set and can't be null or empty.");
        }
        this.bytes = byArray;
        this.contentType = string;
        this.contentId = string2;
        this.contentLocation = string3;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        if (this.toString == null) {
            String string;
            int n = this.bytes.length > 32 ? 32 : this.bytes.length;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = this.bytes[i];
                    if (n2 < 32 || n2 > 127) {
                        n2 = 46;
                    }
                    byArray[i] = n2;
                    int n3 = this.bytes[i];
                    if (n3 < 0) {
                        n3 += 128;
                    }
                    stringBuffer2.append(Integer.toHexString(n3));
                    if (i >= n - 1) continue;
                    stringBuffer2.append("-");
                }
                string = new String(byArray, 0, n, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = PREVIEW_TEXT_ERROR;
            }
            stringBuffer.append("MmsPart {Length: ").append(this.bytes.length);
            stringBuffer.append(", Str-B").append(32).append(": ").append(string);
            stringBuffer.append(", Hex-B").append(32).append(": ").append(stringBuffer2);
            stringBuffer.append(", ContentType: ").append(this.contentType);
            if (this.contentId != null) {
                stringBuffer.append(", ContentID: ").append(this.contentId);
            }
            if (this.contentLocation != null) {
                stringBuffer.append(", ContentLocation: ").append(this.contentLocation);
            }
            stringBuffer.append("}");
            this.toString = stringBuffer.toString();
        }
        return this.toString;
    }
}

