/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.ems;

import hr.tis.ems.InformationElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class EMSOutputStream
extends ByteArrayOutputStream {
    private StringBuffer m_text;

    public EMSOutputStream() {
        this.write(0);
    }

    public synchronized void write(InformationElement ie) throws IOException {
        this.write(ie.getIdentifier());
        byte[] payload = ie.getPayload();
        this.write(payload.length);
        this.write(payload);
    }

    public synchronized byte[] toByteArray() {
        int textLen = 0;
        if (this.m_text != null) {
            textLen = this.m_text.length();
            for (int i = 0; i < textLen; ++i) {
                this.write((byte)(this.m_text.charAt(i) & 0xFF));
            }
        }
        byte[] data = super.toByteArray();
        data[0] = (byte)(data.length - 1 - textLen);
        return data;
    }

    public synchronized void write(String s) {
        if (this.m_text != null) {
            this.m_text.append(s);
        } else {
            this.m_text = new StringBuffer(s);
        }
    }

    public synchronized void reset() {
        super.reset();
        this.write(0);
        if (this.m_text != null) {
            this.m_text.setLength(0);
        }
    }
}

