/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.location;

import hr.tis.mgw.client.location.Accuracy;
import java.io.Serializable;
import java.util.Date;

public class Location
implements Serializable {
    private final float longitude;
    private final float latitude;
    private final Accuracy accuracy;
    private final Date time;
    private final String toString;

    public Location(float f, float f2, Accuracy accuracy, Date date) {
        if (accuracy == null || date == null) {
            throw new IllegalArgumentException("accuracy and time cannot be null");
        }
        this.longitude = f;
        this.latitude = f2;
        this.accuracy = accuracy;
        this.time = date;
        this.toString = "Location {Longitude: " + f + ", Latitude: " + f2 + ", " + accuracy + ", Time: " + date + "}";
    }

    public float getLongitude() {
        return this.longitude;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    public Date getTime() {
        return this.time;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Location)) {
            return false;
        }
        Location location = (Location)object;
        if (this.latitude != location.latitude) {
            return false;
        }
        if (this.longitude != location.longitude) {
            return false;
        }
        if (!this.accuracy.equals(location.accuracy)) {
            return false;
        }
        return this.time.equals(location.time);
    }

    public int hashCode() {
        int n = this.longitude != 0.0f ? Float.floatToIntBits(this.longitude) : 0;
        n = (float)(29 * n) + this.latitude != 0.0f ? Float.floatToIntBits(this.latitude) : 0;
        n = 29 * n + this.accuracy.hashCode();
        n = 29 * n + this.time.hashCode();
        return n;
    }

    public String toString() {
        return this.toString;
    }
}

