/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.location;

import hr.tis.mgw.client.GatewayException;
import hr.tis.mgw.client.ParlayXConverter;
import hr.tis.mgw.client.UnknownEndUserAddressException;
import hr.tis.mgw.client.location.Accuracy;
import hr.tis.mgw.client.location.Location;
import hr.tis.mgw.client.location.LocationManager;
import hr.tis.mgw.client.security.NoRouteCredentialsException;
import hr.tis.mgw.client.security.RouteCredentials;
import hr.tis.mgw.client.security.RouteCredentialsHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.www.schema.parlayx.common.v1_0.EndUserIdentifier;
import org.csapi.www.schema.parlayx.terminal_location.v1_0.LocationAccuracy;
import org.csapi.www.schema.parlayx.terminal_location.v1_0.LocationInfo;
import org.csapi.www.wsdl.parlayx.terminal_location.v1_0.service.InvalidArgumentException;
import org.csapi.www.wsdl.parlayx.terminal_location.v1_0.service.MobileTerminalLocationPort;
import org.csapi.www.wsdl.parlayx.terminal_location.v1_0.service.MobileTerminalLocationServiceLocator;
import org.csapi.www.wsdl.parlayx.terminal_location.v1_0.service.PolicyException;
import org.csapi.www.wsdl.parlayx.terminal_location.v1_0.service.UnknownEndUserException;

public class LocationManagerImpl
implements LocationManager {
    private final Log log = LogFactory.getLog((Class)LocationManagerImpl.class);
    private URL mobileTerminalLocationPortAddress;
    private RouteCredentialsHandler routeCredentialsHandler;
    private int timeout = 30000;

    public Location getLocation(String string, String string2, String string3, Accuracy accuracy) throws UnknownEndUserAddressException, GatewayException, NoRouteCredentialsException, RemoteException {
        this.checkDependencies();
        this.validateAddress("requesterAddress", string2);
        this.validateAddress("endUserAddress", string3);
        if (accuracy == null) {
            throw new IllegalArgumentException("accuracy cannot be null");
        }
        try {
            EndUserIdentifier endUserIdentifier = ParlayXConverter.toEndUserIdentifier(string2);
            EndUserIdentifier endUserIdentifier2 = ParlayXConverter.toEndUserIdentifier(string3);
            LocationAccuracy locationAccuracy = ParlayXConverter.toParlayXLocationAccuracy(accuracy);
            MobileTerminalLocationPort mobileTerminalLocationPort = this.createMobileTerminalLocationPort(string);
            this.log.info((Object)("Calling remote 'getLocation' operation at MobileTerminalLocationPort: requesterAddress=" + string2 + " endUserAddress=" + string3 + " accuracy=" + accuracy));
            LocationInfo locationInfo = mobileTerminalLocationPort.getLocation(endUserIdentifier2, endUserIdentifier, locationAccuracy);
            Location location = this.convertToLocation(locationInfo);
            this.log.info((Object)("Returned location: " + location));
            return location;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException(serviceException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException(malformedURIException);
        }
        catch (UnknownEndUserException unknownEndUserException) {
            throw new UnknownEndUserAddressException(unknownEndUserException.getUnknownEndUserException());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            throw new GatewayException(invalidArgumentException.getInvalidArgumentException(), invalidArgumentException.getFaultCode().getLocalPart());
        }
        catch (PolicyException policyException) {
            throw new GatewayException(policyException.getPolicyException(), policyException.getFaultCode().getLocalPart());
        }
        catch (org.csapi.www.wsdl.parlayx.terminal_location.v1_0.service.ServiceException serviceException) {
            throw new GatewayException(serviceException.getServiceException(), serviceException.getFaultCode().getLocalPart());
        }
    }

    private void checkDependencies() {
        if (this.routeCredentialsHandler == null) {
            throw new IllegalStateException("RouteCredentialsHandler has to be set");
        }
        if (this.mobileTerminalLocationPortAddress == null) {
            throw new IllegalStateException("MobileTerminalLocationPortURL has to be set");
        }
    }

    private void validateAddress(String string, String string2) {
        if (string2 == null || string2.trim().equals("")) {
            throw new IllegalArgumentException(string + " cannot be null or empty");
        }
    }

    private MobileTerminalLocationPort createMobileTerminalLocationPort(String string) throws ServiceException, NoRouteCredentialsException {
        RouteCredentials routeCredentials = this.getRouteCredetials(string);
        MobileTerminalLocationServiceLocator mobileTerminalLocationServiceLocator = new MobileTerminalLocationServiceLocator();
        MobileTerminalLocationPort mobileTerminalLocationPort = mobileTerminalLocationServiceLocator.getMobileTerminalLocationPort(this.mobileTerminalLocationPortAddress);
        ((Stub)mobileTerminalLocationPort).setUsername(routeCredentials.getUsername());
        ((Stub)mobileTerminalLocationPort).setPassword(routeCredentials.getPassword());
        ((Stub)mobileTerminalLocationPort).setTimeout(this.timeout);
        return mobileTerminalLocationPort;
    }

    private RouteCredentials getRouteCredetials(String string) throws NoRouteCredentialsException {
        RouteCredentials routeCredentials = this.routeCredentialsHandler.getCredentials(string);
        if (routeCredentials == null) {
            throw new NoRouteCredentialsException("no security credentials found for route ID: " + string);
        }
        return routeCredentials;
    }

    private Location convertToLocation(LocationInfo locationInfo) {
        Accuracy accuracy = ParlayXConverter.fromParlayXLocationAccuracy(locationInfo.getAccuracy());
        return new Location(locationInfo.getLongitude(), locationInfo.getLatitude(), accuracy, locationInfo.getDateTime().getTime());
    }

    public void setMobileTerminalLocationPortURL(String string) throws MalformedURLException {
        this.mobileTerminalLocationPortAddress = new URL(string);
    }

    public String getMobileTerminalLocationPortURL() {
        return this.mobileTerminalLocationPortAddress.toString();
    }

    public void setRouteCredentialsHandler(RouteCredentialsHandler routeCredentialsHandler) {
        this.routeCredentialsHandler = routeCredentialsHandler;
    }

    public RouteCredentialsHandler getRouteCredentialsHandler() {
        return this.routeCredentialsHandler;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }
}

