/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.message;

import hr.kapsch.schema.parlayx.common.v1_0.SendResultType;
import hr.kapsch.wsdl.parlayx.mm.v1_0.service.SendMessageExtensionPort;
import hr.kapsch.wsdl.parlayx.mm.v1_0.service.SendMessageExtensionService;
import hr.kapsch.wsdl.parlayx.mm.v1_0.service.SendMessageExtensionServiceLocator;
import hr.kapsch.wsdl.parlayx.sms.v1_0.service.SendSmsExtensionPort;
import hr.kapsch.wsdl.parlayx.sms.v1_0.service.SendSmsExtensionService;
import hr.kapsch.wsdl.parlayx.sms.v1_0.service.SendSmsExtensionServiceLocator;
import hr.tis.mgw.client.GatewayException;
import hr.tis.mgw.client.ParlayXConverter;
import hr.tis.mgw.client.charging.Charging;
import hr.tis.mgw.client.exceptions.AxisFaultUtility;
import hr.tis.mgw.client.exceptions.MRemoteException;
import hr.tis.mgw.client.message.AbstractBinaryMessage;
import hr.tis.mgw.client.message.DeliveryStatusInfo;
import hr.tis.mgw.client.message.LogoMessage;
import hr.tis.mgw.client.message.Message;
import hr.tis.mgw.client.message.MessageHelper;
import hr.tis.mgw.client.message.MessageId;
import hr.tis.mgw.client.message.MessageManager2;
import hr.tis.mgw.client.message.MmsMessage;
import hr.tis.mgw.client.message.MmsPart;
import hr.tis.mgw.client.message.Priority;
import hr.tis.mgw.client.message.ReceivedLongSmsSegment;
import hr.tis.mgw.client.message.ReceivedMms;
import hr.tis.mgw.client.message.ReceivedSms;
import hr.tis.mgw.client.message.RingToneMessage;
import hr.tis.mgw.client.message.SendResult;
import hr.tis.mgw.client.message.SmsMessage;
import hr.tis.mgw.client.message.notification.MessageListener2;
import hr.tis.mgw.client.message.notification.NotificationManager;
import hr.tis.mgw.client.message.notification.NotificationManagerReceiver;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Stub;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.www.schema.parlayx.common.v1_0.EndUserIdentifier;
import org.csapi.www.schema.parlayx.mm.v1_0.MessageRef;
import org.csapi.www.schema.parlayx.sms.v1_0.DeliveryStatusType;
import org.csapi.www.schema.parlayx.sms.v1_0.SmsType;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.ReceiveMessagePort;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.ReceiveMessageService;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.ReceiveMessageServiceLocator;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.SendMessagePort;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.SendMessageService;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.SendMessageServiceLocator;
import org.csapi.www.wsdl.parlayx.sms.v1_0.notification.ApplicationException;
import org.csapi.www.wsdl.parlayx.sms.v1_0.service.ReceiveSmsPort;
import org.csapi.www.wsdl.parlayx.sms.v1_0.service.ReceiveSmsService;
import org.csapi.www.wsdl.parlayx.sms.v1_0.service.ReceiveSmsServiceLocator;
import org.csapi.www.wsdl.parlayx.sms.v1_0.service.SendSmsPort;
import org.csapi.www.wsdl.parlayx.sms.v1_0.service.SendSmsService;
import org.csapi.www.wsdl.parlayx.sms.v1_0.service.SendSmsServiceLocator;

public class MessageManager2Impl
extends MessageManager2
implements NotificationManagerReceiver {
    private static final Log log = LogFactory.getLog((Class)MessageManager2Impl.class);
    private static final String SEND_SMS_PORT = "SendSmsPort";
    private static final String RECEIVE_SMS_PORT = "ReceiveSmsPort";
    private static final String SEND_MESSAGE_PORT = "SendMessagePort";
    private static final String RECEIVE_MESSAGE_PORT = "ReceiveMessagePort";
    private static final String SEND_SMS_EXTENSION_PORT = "SendSmsExtensionPort";
    private static final String SEND_MESSAGE_EXTENSION_PORT = "SendMessageExtensionPort";
    private URL sendSmsPortURL;
    private URL receiveSmsPortURL;
    private URL sendMessagePortURL;
    private URL receiveMessagePortURL;
    private URL sendSmsExtensionPortURL;
    private URL sendMessageExtensionPortURL;
    private SendSmsService sendSmsService;
    private ReceiveSmsService receiveSmsService;
    private SendMessageService sendMessageService;
    private ReceiveMessageService receiveMessageService;
    private SendSmsExtensionService sendSmsExtensionService;
    private SendMessageExtensionService sendMessageExtensionService;

    public MessageManager2Impl() {
        this.initializeAxis();
    }

    public MessageManager2Impl(String string) {
        this.setServerURL(string);
        this.initializeAxis();
    }

    public MessageManager2Impl(String string, String string2, String string3) {
        this.validateCredentials(string2, string3);
        this.setUsername(string2);
        this.setPassword(string3);
        this.setServerURL(string);
        this.initializeAxis();
    }

    public DeliveryStatusInfo[] getMessageDeliveryStatus(MessageId messageId) throws GatewayException {
        return this.getMessageDeliveryStatus(messageId, this.username, this.password);
    }

    public DeliveryStatusInfo[] getMessageDeliveryStatus(MessageId messageId, String string, String string2) throws GatewayException {
        this.validatePortsURLs();
        this.validateMessageId(messageId);
        this.validateCredentials(string, string2);
        try {
            this.logDebugGetMessageDeliveryStatus(messageId, string, string2);
            if (messageId.getPort() == 1) {
                SendSmsPort sendSmsPort = this.getSendSmsPort(string, string2);
                DeliveryStatusType[] deliveryStatusTypeArray = sendSmsPort.getSmsDeliveryStatus(messageId.getId());
                return ParlayXConverter.fromParlayXDeliveryStatusTypes(deliveryStatusTypeArray);
            }
            if (messageId.getPort() == 2) {
                SendMessagePort sendMessagePort = this.getSendMessagePort(string, string2);
                org.csapi.www.schema.parlayx.mm.v1_0.DeliveryStatusType[] deliveryStatusTypeArray = sendMessagePort.getMessageDeliveryStatus(messageId.getId());
                return ParlayXConverter.fromParlayXDeliveryStatusTypes(deliveryStatusTypeArray);
            }
            throw new IllegalStateException("MessageId has invalid type: " + messageId.getPort());
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
    }

    private void logDebugGetMessageDeliveryStatus(MessageId messageId, String string, String string2) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Required Message Delivery {").append(messageId);
            stringBuffer.append(", Username: ").append(string);
            stringBuffer.append(", Password: ").append(string2);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public ReceivedSms[] receiveSmsMessages(String string) throws GatewayException {
        return this.receiveSmsMessages(string, this.username, this.password);
    }

    public ReceivedSms[] receiveSmsMessages(String string, String string2, String string3) throws GatewayException {
        this.validatePortsURLs();
        this.validateRegistrationId(string);
        this.validateCredentials(string2, string3);
        try {
            this.logDebugReceiveSmsMessage(string, string2, string3);
            ReceiveSmsPort receiveSmsPort = this.getReceiveSmsPort(string2, string3);
            SmsType[] smsTypeArray = receiveSmsPort.getReceivedSms(string);
            return this.fromParlayXSmsType(smsTypeArray, string);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
    }

    private void logDebugReceiveSmsMessage(String string, String string2, String string3) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Receiving sms messages {Registration ID: ").append(string);
            stringBuffer.append(", Username: ").append(string2);
            stringBuffer.append(", Password: ").append(string3);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public ReceivedMms[] receiveMmsMessages(String string, Priority priority) throws GatewayException {
        return this.receiveMmsMessages(string, priority, this.username, this.password);
    }

    public ReceivedMms[] receiveMmsMessages(String string, Priority priority, String string2, String string3) throws GatewayException {
        this.validatePortsURLs();
        this.validateRegistrationId(string);
        this.validateCredentials(string2, string3);
        try {
            this.logDebugReceiveMmsMessages(string, string2, string3);
            ReceiveMessagePort receiveMessagePort = this.getReceiveMessagePort(string2, string3);
            MessageRef[] messageRefArray = receiveMessagePort.getReceivedMessages(string, ParlayXConverter.toParlayXMessagePriority(priority));
            return this.populateMmses(this.fromParlayXMessageRefs(messageRefArray, string), string2, string3);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
    }

    private void logDebugReceiveMmsMessages(String string, String string2, String string3) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Receiving multimedia messages {Registration ID: ").append(string);
            stringBuffer.append(", Username: ").append(string2);
            stringBuffer.append(", Password: ").append(string3);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public MessageId sendMessage(Message message, String[] stringArray, String string, Priority priority, Charging charging) throws GatewayException {
        return this.sendMessage(message, stringArray, string, priority, charging, this.username, this.password);
    }

    public MessageId sendMessage(Message message, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validatePortsURLs();
        this.validateMessage(message);
        this.validateCredentials(string2, string3);
        this.logDebugSendMessage(message, string, stringArray, charging, string2, string3);
        return message.send(this, stringArray, string, priority, charging, string2, string3);
    }

    public SendResult sendMessageWithResult(Message message, String[] stringArray, String string, Priority priority, Charging charging) throws GatewayException {
        return this.sendMessageWithResult(message, stringArray, string, priority, charging, this.username, this.password);
    }

    public SendResult sendMessageWithResult(Message message, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validatePortsURLs();
        this.validateExtensionPortsURLs();
        this.validateMessage(message);
        this.validateCredentials(string2, string3);
        this.logDebugSendMessage(message, string, stringArray, charging, string2, string3);
        return message.sendWithResult(this, stringArray, string, priority, charging, string2, string3);
    }

    private void logDebugSendMessage(Message message, String string, String[] stringArray, Charging charging, String string2, String string3) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Sending " + message + " - {Source: " + string + ", Destination: (");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    if (i >= stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            } else {
                stringBuffer.append(stringArray);
            }
            stringBuffer.append("), ");
            stringBuffer.append(charging != null ? charging.toString() : "Charging: -- NOT SET --");
            stringBuffer.append(", Username: ").append(string2);
            stringBuffer.append(", Password: ").append(string3);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    MessageId sendSms(SmsMessage smsMessage, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validateOriginatorAddresses(string);
        this.validateDestinationAddresses(stringArray);
        try {
            SendSmsPort sendSmsPort = this.getSendSmsPort(string2, string3);
            String string4 = sendSmsPort.sendSms(ParlayXConverter.toEndUserIdentifiers(stringArray), string, this.chargingReservationId(charging), smsMessage.getText());
            return new MessageId(string4, 1);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    MessageId sendRingTone(RingToneMessage ringToneMessage, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validateOriginatorAddresses(string);
        this.validateDestinationAddresses(stringArray);
        try {
            SendSmsPort sendSmsPort = this.getSendSmsPort(string2, string3);
            String string4 = sendSmsPort.sendSmsRingTone(ParlayXConverter.toEndUserIdentifiers(stringArray), string, this.chargingReservationId(charging), ringToneMessage.getMelody(), ParlayXConverter.toParlayXSmsFormat(ringToneMessage.getSmsFormat()));
            return new MessageId(string4, 1);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    MessageId sendLogo(LogoMessage logoMessage, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validateOriginatorAddresses(string);
        this.validateDestinationAddresses(stringArray);
        try {
            SendSmsPort sendSmsPort = this.getSendSmsPort(string2, string3);
            String string4 = sendSmsPort.sendSmsLogo(ParlayXConverter.toEndUserIdentifiers(stringArray), string, this.chargingReservationId(charging), logoMessage.getImage(), ParlayXConverter.toParlayXSmsFormat(logoMessage.getSmsFormat()));
            return new MessageId(string4, 1);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    MessageId sendMms(MmsMessage mmsMessage, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validateDestinationAddresses(stringArray);
        try {
            SendMessagePort sendMessagePort = this.getSendMessagePort(string2, string3);
            List list = mmsMessage.getParts();
            Object object = list.iterator();
            while (object.hasNext()) {
                MmsPart mmsPart = (MmsPart)object.next();
                ((Stub)sendMessagePort).addAttachment((Object)this.createPart(mmsPart.getBytes(), mmsPart.getContentType(), mmsPart.getContentId(), mmsPart.getContentLocation()));
            }
            object = sendMessagePort.sendMessage(ParlayXConverter.toEndUserIdentifiers(stringArray), this.optional(string), this.optional(mmsMessage.getSubject()), ParlayXConverter.toParlayXMessagePriority(priority), this.optional(this.chargingReservationId(charging)));
            return new MessageId((String)object, 2);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    MessageId sendBinaryMessage(AbstractBinaryMessage abstractBinaryMessage, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validateDestinationAddresses(stringArray);
        try {
            SendMessagePort sendMessagePort = this.getSendMessagePort(string2, string3);
            List list = abstractBinaryMessage.getBinaryAttachmentsList();
            Object object = list.iterator();
            while (object.hasNext()) {
                byte[] byArray = (byte[])object.next();
                ((Stub)sendMessagePort).addAttachment((Object)this.createPart(byArray, abstractBinaryMessage.getContentType(), null, null));
            }
            object = sendMessagePort.sendMessage(ParlayXConverter.toEndUserIdentifiers(stringArray), this.optional(string), this.optional(null), ParlayXConverter.toParlayXMessagePriority(priority), this.optional(this.chargingReservationId(charging)));
            return new MessageId((String)object, 2);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    SendResult sendSmsWithResult(SmsMessage smsMessage, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validateOriginatorAddresses(string);
        this.validateDestinationAddresses(stringArray);
        try {
            SendSmsExtensionPort sendSmsExtensionPort = this.getSendSmsExtensionPort(string2, string3);
            SendResultType sendResultType = sendSmsExtensionPort.sendSms(ParlayXConverter.toEndUserIdentifiers(stringArray), string, this.chargingReservationId(charging), smsMessage.getText());
            return new SendResult(new MessageId(sendResultType.getRequestIdentifier(), 1), sendResultType.getCount());
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    SendResult sendMmsWithResult(MmsMessage mmsMessage, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validateDestinationAddresses(stringArray);
        try {
            SendMessageExtensionPort sendMessageExtensionPort = this.getSendMessageExtensionPort(string2, string3);
            List list = mmsMessage.getParts();
            Object object = list.iterator();
            while (object.hasNext()) {
                MmsPart mmsPart = (MmsPart)object.next();
                ((Stub)sendMessageExtensionPort).addAttachment((Object)this.createPart(mmsPart.getBytes(), mmsPart.getContentType(), mmsPart.getContentId(), mmsPart.getContentLocation()));
            }
            object = sendMessageExtensionPort.sendMessage(ParlayXConverter.toEndUserIdentifiers(stringArray), this.optional(string), this.optional(mmsMessage.getSubject()), ParlayXConverter.toParlayXMessagePriority(priority), this.optional(this.chargingReservationId(charging)));
            return new SendResult(new MessageId(((SendResultType)object).getRequestIdentifier(), 2), ((SendResultType)object).getCount());
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    SendResult sendBinaryMessageWithResult(AbstractBinaryMessage abstractBinaryMessage, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        this.validateDestinationAddresses(stringArray);
        try {
            SendMessageExtensionPort sendMessageExtensionPort = this.getSendMessageExtensionPort(string2, string3);
            List list = abstractBinaryMessage.getBinaryAttachmentsList();
            Object object = list.iterator();
            while (object.hasNext()) {
                byte[] byArray = (byte[])object.next();
                ((Stub)sendMessageExtensionPort).addAttachment((Object)this.createPart(byArray, abstractBinaryMessage.getContentType(), null, null));
            }
            object = sendMessageExtensionPort.sendMessage(ParlayXConverter.toEndUserIdentifiers(stringArray), this.optional(string), this.optional(null), ParlayXConverter.toParlayXMessagePriority(priority), this.optional(this.chargingReservationId(charging)));
            return new SendResult(new MessageId(((SendResultType)object).getRequestIdentifier(), 2), ((SendResultType)object).getCount());
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    public void registerMessageListener(String string, MessageListener2 messageListener2) {
        this.registerMessageListener(string, messageListener2, this.username, this.password);
    }

    public void registerMessageListener(String string, MessageListener2 messageListener2, String string2, String string3) {
        this.validateRegistrationId(string);
        this.validateMessageListener(messageListener2);
        this.validateCredentials(string2, string3);
        NotificationManager.getManager().registerReceiver(string == REG_ID_ANY ? null : string, this);
        this.listeners.put(string, new PrivateListener(messageListener2, string2, string3));
    }

    public void cancelMessageListenerRegistration(String string) {
        NotificationManager.getManager().removeReceiver(string == REG_ID_ANY ? null : string);
        this.listeners.remove(string);
    }

    public void notifySmsReception(String string, String string2, EndUserIdentifier endUserIdentifier, String string3) throws RemoteException, ApplicationException {
        PrivateListener privateListener = this.retrieveListener(string);
        if (privateListener != null) {
            final ReceivedSms receivedSms = new ReceivedSms(new SmsMessage(string3), ParlayXConverter.fromEndUserIdentifier(endUserIdentifier), string2, string);
            final MessageListener2 messageListener2 = privateListener.messageListener;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling message listener with: " + receivedSms));
            }
            this.runListener(new Runnable(){

                public void run() {
                    try {
                        if (MessageHelper.isDeliveryReport(receivedSms)) {
                            messageListener2.deliveryReportReceived(MessageHelper.createDeliveryReport(receivedSms));
                        } else {
                            messageListener2.smsReceived(receivedSms);
                        }
                    }
                    catch (Throwable throwable) {
                        log.error((Object)"Caught unhandled exception in message listener received SMS method.", throwable);
                    }
                }
            });
        } else {
            log.error((Object)("No registered message listener for Registration ID: " + string));
        }
    }

    public void notifyMessageReception(String string, MessageRef messageRef) throws RemoteException, org.csapi.www.wsdl.parlayx.mm.v1_0.notification.ApplicationException {
        PrivateListener privateListener = this.retrieveListener(string);
        if (privateListener != null) {
            try {
                final ReceivedMms receivedMms = this.populateMms(this.fromParlayXMessageRef(messageRef, string), privateListener.username, privateListener.password);
                final MessageListener2 messageListener2 = privateListener.messageListener;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Calling message listener with: " + receivedMms));
                }
                this.runListener(new Runnable(){

                    public void run() {
                        try {
                            if (MessageHelper.isDeliveryReport(receivedMms)) {
                                messageListener2.deliveryReportReceived(MessageHelper.createDeliveryReport(receivedMms));
                            } else {
                                messageListener2.mmsReceived(receivedMms);
                            }
                        }
                        catch (Throwable throwable) {
                            log.error((Object)"Caught unhandled exception in message listener received MMS method.", throwable);
                        }
                    }
                });
            }
            catch (GatewayException gatewayException) {
                log.error((Object)"Can't retrieve attachments for multimedia message on notification request.", (Throwable)gatewayException);
                throw new org.csapi.www.wsdl.parlayx.mm.v1_0.notification.ApplicationException("Can't retrieve attachments for multimedia message.", gatewayException);
            }
        } else {
            log.error((Object)("No registered message listener for Registration ID: " + string));
        }
    }

    public void notifyLongSmsReception(String string, String string2, String string3, String string4, int n, int n2, int n3) throws RemoteException {
        PrivateListener privateListener = this.retrieveListener(string);
        if (privateListener != null) {
            final MessageListener2 messageListener2 = privateListener.messageListener;
            final ReceivedLongSmsSegment receivedLongSmsSegment = new ReceivedLongSmsSegment(string, string4, string3, string2, n, n2, n3);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling message listener with: " + receivedLongSmsSegment));
            }
            this.runListener(new Runnable(){

                public void run() {
                    try {
                        messageListener2.longSmsReceived(receivedLongSmsSegment);
                    }
                    catch (Throwable throwable) {
                        log.error((Object)"Caught unhandled exception in message listener received MMS method.", throwable);
                    }
                }
            });
        } else {
            log.error((Object)("No registered message listener for Registration ID: " + string));
        }
    }

    private PrivateListener retrieveListener(String string) {
        PrivateListener privateListener = (PrivateListener)this.listeners.get(string);
        if (privateListener == null) {
            privateListener = (PrivateListener)this.listeners.get(REG_ID_ANY);
        }
        return privateListener;
    }

    private void validatePortsURLs() {
        if (this.sendSmsPortURL == null || this.receiveSmsPortURL == null || this.sendMessagePortURL == null || this.receiveMessagePortURL == null) {
            throw new IllegalStateException("ServerURL must be set.");
        }
    }

    private void validateExtensionPortsURLs() {
        if (this.sendSmsExtensionPortURL == null || this.sendMessageExtensionPortURL == null) {
            throw new IllegalStateException("ServerURL must be set.");
        }
    }

    protected void initPortsURLs() {
        try {
            this.sendSmsPortURL = new URL(this.serverURL + SEND_SMS_PORT);
            this.receiveSmsPortURL = new URL(this.serverURL + RECEIVE_SMS_PORT);
            this.sendMessagePortURL = new URL(this.serverURL + SEND_MESSAGE_PORT);
            this.receiveMessagePortURL = new URL(this.serverURL + RECEIVE_MESSAGE_PORT);
            this.sendSmsExtensionPortURL = new URL(this.serverURL + SEND_SMS_EXTENSION_PORT);
            this.sendMessageExtensionPortURL = new URL(this.serverURL + SEND_MESSAGE_EXTENSION_PORT);
            log.info((Object)("MessageManager2 initialized. URLs :: SendSmsPort-> " + this.sendSmsPortURL + ", ReceiveSmsPort-> " + this.receiveSmsPortURL + ", SendMessagePort-> " + this.sendMessagePortURL + ", ReceiveMessagePort-> " + this.receiveMessagePortURL + ", SendSmsExtensionPort-> " + this.sendSmsExtensionPortURL + ", SendMessageExtensionPort-> " + this.sendMessageExtensionPortURL));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Not valid ServerURL: " + this.serverURL);
        }
    }

    SendSmsPort getSendSmsPort(String string, String string2) {
        try {
            SendSmsPort sendSmsPort = this.sendSmsService.getSendSmsPort(this.sendSmsPortURL);
            this.applyCredentialsToStub(string, string2, (Stub)sendSmsPort);
            this.applyTimeoutToStub((Stub)sendSmsPort);
            return sendSmsPort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate send sms port.", serviceException);
        }
    }

    ReceiveSmsPort getReceiveSmsPort(String string, String string2) {
        try {
            ReceiveSmsPort receiveSmsPort = this.receiveSmsService.getReceiveSmsPort(this.receiveSmsPortURL);
            this.applyCredentialsToStub(string, string2, (Stub)receiveSmsPort);
            this.applyTimeoutToStub((Stub)receiveSmsPort);
            return receiveSmsPort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate receive sms port.", serviceException);
        }
    }

    SendMessagePort getSendMessagePort(String string, String string2) {
        try {
            SendMessagePort sendMessagePort = this.sendMessageService.getSendMessagePort(this.sendMessagePortURL);
            this.applyCredentialsToStub(string, string2, (Stub)sendMessagePort);
            this.applyTimeoutToStub((Stub)sendMessagePort);
            return sendMessagePort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate send message port.", serviceException);
        }
    }

    ReceiveMessagePort getReceiveMessagePort(String string, String string2) {
        try {
            ReceiveMessagePort receiveMessagePort = this.receiveMessageService.getReceiveMessagePort(this.receiveMessagePortURL);
            this.applyCredentialsToStub(string, string2, (Stub)receiveMessagePort);
            this.applyTimeoutToStub((Stub)receiveMessagePort);
            return receiveMessagePort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate receive message port.", serviceException);
        }
    }

    SendSmsExtensionPort getSendSmsExtensionPort(String string, String string2) {
        try {
            SendSmsExtensionPort sendSmsExtensionPort = this.sendSmsExtensionService.getSendSmsExtensionPort(this.sendSmsExtensionPortURL);
            this.applyCredentialsToStub(string, string2, (Stub)sendSmsExtensionPort);
            this.applyTimeoutToStub((Stub)sendSmsExtensionPort);
            return sendSmsExtensionPort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate send sms extension port.", serviceException);
        }
    }

    SendMessageExtensionPort getSendMessageExtensionPort(String string, String string2) {
        try {
            SendMessageExtensionPort sendMessageExtensionPort = this.sendMessageExtensionService.getSendMessageExtensionPort(this.sendMessageExtensionPortURL);
            this.applyCredentialsToStub(string, string2, (Stub)sendMessageExtensionPort);
            this.applyTimeoutToStub((Stub)sendMessageExtensionPort);
            return sendMessageExtensionPort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate send message extension port.", serviceException);
        }
    }

    private ReceivedSms[] fromParlayXSmsType(SmsType[] smsTypeArray, String string) {
        ReceivedSms[] receivedSmsArray = new ReceivedSms[smsTypeArray.length];
        for (int i = 0; i < smsTypeArray.length; ++i) {
            receivedSmsArray[i] = new ReceivedSms(new SmsMessage(smsTypeArray[i].getMessage()), ParlayXConverter.fromEndUserIdentifier(smsTypeArray[i].getSenderAddress()), null, string);
        }
        return receivedSmsArray;
    }

    private ReceivedMms fromParlayXMessageRef(MessageRef messageRef, String string) {
        return new ReceivedMms(messageRef.getMessageRefIdentifier(), ParlayXConverter.fromEndUserIdentifier(messageRef.getSenderAddress()), messageRef.getMessageServiceActivationNumber(), messageRef.getSubject(), messageRef.getMessage(), ParlayXConverter.fromParlayXMessagePriority(messageRef.getPriority()), string);
    }

    private ReceivedMms[] fromParlayXMessageRefs(MessageRef[] messageRefArray, String string) {
        ReceivedMms[] receivedMmsArray = new ReceivedMms[messageRefArray.length];
        for (int i = 0; i < messageRefArray.length; ++i) {
            receivedMmsArray[i] = this.fromParlayXMessageRef(messageRefArray[i], string);
        }
        return receivedMmsArray;
    }

    private ReceivedMms populateMms(ReceivedMms receivedMms, String string, String string2) throws GatewayException {
        if (!receivedMms.isPopulated()) {
            try {
                ReceiveMessagePort receiveMessagePort = this.getReceiveMessagePort(string, string2);
                receiveMessagePort.getMessage(receivedMms.getRefId());
                Object[] objectArray = ((Stub)receiveMessagePort).getAttachments();
                MmsMessage mmsMessage = receivedMms.getMmsMessage();
                for (int i = 0; i < objectArray.length; ++i) {
                    AttachmentPart attachmentPart = (AttachmentPart)objectArray[i];
                    byte[] byArray = this.bytesFromAttachmentPart(attachmentPart);
                    String string3 = attachmentPart.getContentType();
                    String string4 = attachmentPart.getContentId();
                    String string5 = attachmentPart.getContentLocation();
                    mmsMessage.addPart(new MmsPart(byArray, string3, string4, string5));
                }
            }
            catch (AxisFault axisFault) {
                throw AxisFaultUtility.convertAxisFaultException(axisFault);
            }
            catch (RemoteException remoteException) {
                throw new MRemoteException(remoteException);
            }
            catch (IOException iOException) {
                throw new GatewayException(iOException);
            }
            catch (SOAPException sOAPException) {
                throw new GatewayException(sOAPException);
            }
        }
        return receivedMms;
    }

    private byte[] bytesFromAttachmentPart(AttachmentPart attachmentPart) throws SOAPException, IOException {
        byte[] byArray = new byte[attachmentPart.getSize()];
        InputStream inputStream = attachmentPart.getDataHandler().getInputStream();
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        return byArray;
    }

    private ReceivedMms[] populateMmses(ReceivedMms[] receivedMmsArray, String string, String string2) throws GatewayException {
        for (int i = 0; i < receivedMmsArray.length; ++i) {
            receivedMmsArray[i] = this.populateMms(receivedMmsArray[i], string, string2);
        }
        return receivedMmsArray;
    }

    private AttachmentPart createPart(byte[] byArray, String string, String string2, String string3) {
        AttachmentPart attachmentPart = new AttachmentPart();
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, string);
        attachmentPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
        if (string2 != null) {
            attachmentPart.setContentId(string2);
        }
        if (string3 != null) {
            attachmentPart.setContentLocation(string3);
        }
        return attachmentPart;
    }

    protected String chargingReservationId(Charging charging) {
        return charging != null ? charging.getReservationId() : null;
    }

    protected void initAxisServices() {
        this.sendSmsService = new SendSmsServiceLocator();
        this.receiveSmsService = new ReceiveSmsServiceLocator();
        this.sendMessageService = new SendMessageServiceLocator();
        this.receiveMessageService = new ReceiveMessageServiceLocator();
        this.sendSmsExtensionService = new SendSmsExtensionServiceLocator();
        this.sendMessageExtensionService = new SendMessageExtensionServiceLocator();
    }

    private class PrivateListener {
        MessageListener2 messageListener;
        String username;
        String password;

        public PrivateListener(MessageListener2 messageListener2, String string, String string2) {
            this.messageListener = messageListener2;
            this.username = string;
            this.password = string2;
        }
    }
}

