/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.message;

import hr.tis.mgw.client.GatewayException;
import hr.tis.mgw.client.ParlayXConverter;
import hr.tis.mgw.client.UnknownEndUserAddressException;
import hr.tis.mgw.client.message.Attachment;
import hr.tis.mgw.client.message.DeliveryStatusInfo;
import hr.tis.mgw.client.message.Message;
import hr.tis.mgw.client.message.MessageManager;
import hr.tis.mgw.client.message.MessageTooLargeException;
import hr.tis.mgw.client.message.MmsMessage;
import hr.tis.mgw.client.message.Priority;
import hr.tis.mgw.client.message.SmsMessage;
import hr.tis.mgw.client.message.UnknownMessageIdentifierException;
import hr.tis.mgw.client.message.notification.MessageListener;
import hr.tis.mgw.client.message.notification.MmNotificationPortImpl;
import hr.tis.mgw.client.message.notification.NotificationManager;
import hr.tis.mgw.client.message.notification.NotificationManagerReceiver;
import hr.tis.mgw.client.message.wap.PushSIMessage;
import hr.tis.mgw.client.security.NoRouteCredentialsException;
import hr.tis.mgw.client.security.RouteCredentials;
import hr.tis.mgw.client.security.RouteCredentialsHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.AttachmentPart;
import org.apache.axis.client.Stub;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.www.schema.parlayx.common.v1_0.EndUserIdentifier;
import org.csapi.www.schema.parlayx.mm.v1_0.DeliveryStatusType;
import org.csapi.www.schema.parlayx.mm.v1_0.MessagePriority;
import org.csapi.www.schema.parlayx.mm.v1_0.MessageRef;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.InvalidArgumentException;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.MessageTooLongException;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.PolicyException;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.ReceiveMessagePort;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.ReceiveMessageServiceLocator;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.SendMessagePort;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.SendMessageServiceLocator;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.UnknownEndUserException;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.UnknownMessageException;
import org.csapi.www.wsdl.parlayx.mm.v1_0.service.UnknownRequestIdentifierException;
import org.csapi.www.wsdl.parlayx.sms.v1_0.notification.ApplicationException;

public class MessageManagerImpl
implements MessageManager,
NotificationManagerReceiver {
    private final Log log = LogFactory.getLog((Class)MessageManagerImpl.class);
    private URL sendMessagePortAddress;
    private URL receiveMessagePortAddress;
    private RouteCredentialsHandler routeCredentialsHandler;
    private int timeout = 30000;
    private Map listeners = new HashMap();

    public String sendMessage(String string, Message message, String string2, String[] stringArray, Priority priority, String string3) throws GatewayException, MessageTooLargeException, UnknownEndUserAddressException, NoRouteCredentialsException, RemoteException {
        if (!(message instanceof SmsMessage || message instanceof MmsMessage || message instanceof PushSIMessage)) {
            throw new IllegalArgumentException("Message type not supported.");
        }
        if (this.routeCredentialsHandler == null) {
            throw new IllegalStateException("RouteCredentialsHandler has to be set");
        }
        if (this.sendMessagePortAddress == null) {
            throw new IllegalStateException("SendMessagePortURL has to be set");
        }
        try {
            if (message == null) {
                throw new IllegalArgumentException("message is null");
            }
            this.validateAddresses(new String[]{string2});
            if (stringArray == null) {
                throw new IllegalArgumentException("list of end user addresses is null");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("list of end user addresses is empty");
            }
            this.validateAddresses(stringArray);
            MessagePriority messagePriority = ParlayXConverter.toParlayXMessagePriority(priority);
            EndUserIdentifier[] endUserIdentifierArray = this.convertToEndUserIdentifiers(stringArray);
            SendMessagePort sendMessagePort = this.createSendMessagePort(string);
            Attachment[] attachmentArray = message.getAttachments();
            this.log.debug((Object)("Message content will be sent as " + attachmentArray.length + " SOAP attachment(s)"));
            for (int i = 0; i < attachmentArray.length; ++i) {
                AttachmentPart attachmentPart = attachmentArray[i].getPart();
                ((Stub)sendMessagePort).addAttachment((Object)attachmentPart);
            }
            if (string3 == null) {
                string3 = "";
            }
            this.log.info((Object)("Calling remote 'sendMessage' operation at SendMessagePort: message=" + message + " serviceAddress=" + string2 + " endUserAddresses=" + Arrays.asList(stringArray) + " messagePriority=" + messagePriority + " charging=" + string3));
            String string4 = sendMessagePort.sendMessage(endUserIdentifierArray, string2, message.getSubject(), messagePriority, string3);
            this.log.info((Object)("Returned message ID: " + string4));
            return string4;
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException(malformedURIException);
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException(serviceException);
        }
        catch (MessageTooLongException messageTooLongException) {
            throw new MessageTooLargeException(messageTooLongException.getMessageTooLongException());
        }
        catch (UnknownEndUserException unknownEndUserException) {
            throw new UnknownEndUserAddressException(unknownEndUserException.getUnknownEndUserException());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            throw new GatewayException(invalidArgumentException.getInvalidArgumentException(), invalidArgumentException.getFaultCode().getLocalPart());
        }
        catch (PolicyException policyException) {
            throw new GatewayException(policyException.getPolicyException(), policyException.getFaultCode().getLocalPart(), policyException.getFaultString());
        }
        catch (org.csapi.www.wsdl.parlayx.mm.v1_0.service.ServiceException serviceException) {
            throw new GatewayException(serviceException.getServiceException(), serviceException.getFaultCode().getLocalPart(), serviceException.getFaultString());
        }
    }

    private EndUserIdentifier[] convertToEndUserIdentifiers(String[] stringArray) throws URI.MalformedURIException {
        EndUserIdentifier[] endUserIdentifierArray = new EndUserIdentifier[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            endUserIdentifierArray[i] = ParlayXConverter.toEndUserIdentifier(stringArray[i]);
        }
        return endUserIdentifierArray;
    }

    private SendMessagePort createSendMessagePort(String string) throws ServiceException, NoRouteCredentialsException {
        RouteCredentials routeCredentials = this.getRouteCredetials(string);
        SendMessageServiceLocator sendMessageServiceLocator = new SendMessageServiceLocator();
        SendMessagePort sendMessagePort = sendMessageServiceLocator.getSendMessagePort(this.sendMessagePortAddress);
        ((Stub)sendMessagePort).setUsername(routeCredentials.getUsername());
        ((Stub)sendMessagePort).setPassword(routeCredentials.getPassword());
        ((Stub)sendMessagePort).setTimeout(this.timeout);
        return sendMessagePort;
    }

    private void validateAddresses(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && !stringArray[i].trim().equals("")) continue;
            throw new IllegalArgumentException("invalid address: " + stringArray[i]);
        }
    }

    public DeliveryStatusInfo[] getMessageDeliveryStatus(String string, String string2) throws GatewayException, UnknownMessageIdentifierException, NoRouteCredentialsException, RemoteException {
        if (this.routeCredentialsHandler == null) {
            throw new IllegalStateException("RouteCredentialsHandler has to be set");
        }
        if (this.sendMessagePortAddress == null) {
            throw new IllegalStateException("SendMessagePortURL has to be set");
        }
        try {
            SendMessagePort sendMessagePort = this.createSendMessagePort(string);
            this.log.info((Object)("Calling remote 'getMessageDeliveryStatus' operation (SendMessagePort): messageId=" + string2));
            DeliveryStatusType[] deliveryStatusTypeArray = sendMessagePort.getMessageDeliveryStatus(string2);
            DeliveryStatusInfo[] deliveryStatusInfoArray = ParlayXConverter.fromParlayXDeliveryStatusTypes(deliveryStatusTypeArray);
            this.log.info((Object)("Returned delivery status(es): " + Arrays.asList(deliveryStatusInfoArray)));
            return deliveryStatusInfoArray;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException(serviceException);
        }
        catch (UnknownRequestIdentifierException unknownRequestIdentifierException) {
            throw new UnknownMessageIdentifierException(unknownRequestIdentifierException.getUnknownRequestIdentifierException());
        }
        catch (PolicyException policyException) {
            throw new GatewayException(policyException.getPolicyException(), policyException.getFaultCode().getLocalPart());
        }
        catch (org.csapi.www.wsdl.parlayx.mm.v1_0.service.ServiceException serviceException) {
            throw new GatewayException(serviceException.getServiceException(), serviceException.getFaultCode().getLocalPart());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            throw new GatewayException(invalidArgumentException.getInvalidArgumentException(), invalidArgumentException.getFaultCode().getLocalPart());
        }
    }

    public Attachment[] getMessageAttachments(String string, String string2) throws GatewayException, UnknownMessageIdentifierException, NoRouteCredentialsException, RemoteException {
        if (this.routeCredentialsHandler == null) {
            throw new IllegalStateException("RouteCredentialsHandler has to be set");
        }
        if (this.receiveMessagePortAddress == null) {
            throw new IllegalStateException("ReceiveMessagePortURL has to be set");
        }
        try {
            ReceiveMessagePort receiveMessagePort = this.createReceiveMessagePort(string);
            this.log.info((Object)("Calling remote 'getMessage' operation (ReceiveMessagePort): messageRefID=" + string2));
            receiveMessagePort.getMessage(string2);
            Object[] objectArray = ((Stub)receiveMessagePort).getAttachments();
            this.log.debug((Object)("Requested MMS contains " + objectArray.length + " attachment(s)"));
            Attachment[] attachmentArray = this.convertToAttachments(objectArray);
            return attachmentArray;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException(serviceException);
        }
        catch (PolicyException policyException) {
            throw new GatewayException(policyException.getPolicyException(), policyException.getFaultCode().getLocalPart());
        }
        catch (org.csapi.www.wsdl.parlayx.mm.v1_0.service.ServiceException serviceException) {
            throw new GatewayException(serviceException.getServiceException(), serviceException.getFaultCode().getLocalPart());
        }
        catch (UnknownMessageException unknownMessageException) {
            throw new UnknownMessageIdentifierException(unknownMessageException.getUnknownMessageException());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            throw new GatewayException(invalidArgumentException.getInvalidArgumentException(), invalidArgumentException.getFaultCode().getLocalPart());
        }
    }

    public void registerMessageListener(String string, MessageListener messageListener) {
        if (messageListener == null) {
            throw new IllegalArgumentException("MessageListener has to be set");
        }
        NotificationManager.getManager().registerReceiver(string, this);
        MmNotificationPortImpl mmNotificationPortImpl = new MmNotificationPortImpl();
        mmNotificationPortImpl.setMessageListener(messageListener);
        mmNotificationPortImpl.setMessageManager(this);
        this.listeners.put(string, mmNotificationPortImpl);
    }

    public void cancelMessageListenerRegistration(String string) {
        NotificationManager.getManager().removeReceiver(string);
        this.listeners.remove(string);
    }

    private Attachment[] convertToAttachments(Object[] objectArray) {
        Attachment[] attachmentArray = new Attachment[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            AttachmentPart attachmentPart = (AttachmentPart)objectArray[i];
            attachmentArray[i] = new Attachment(attachmentPart);
        }
        return attachmentArray;
    }

    private ReceiveMessagePort createReceiveMessagePort(String string) throws ServiceException, NoRouteCredentialsException {
        RouteCredentials routeCredentials = this.getRouteCredetials(string);
        ReceiveMessageServiceLocator receiveMessageServiceLocator = new ReceiveMessageServiceLocator();
        ReceiveMessagePort receiveMessagePort = receiveMessageServiceLocator.getReceiveMessagePort(this.receiveMessagePortAddress);
        ((Stub)receiveMessagePort).setUsername(routeCredentials.getUsername());
        ((Stub)receiveMessagePort).setPassword(routeCredentials.getPassword());
        ((Stub)receiveMessagePort).setTimeout(this.timeout);
        return receiveMessagePort;
    }

    private RouteCredentials getRouteCredetials(String string) throws NoRouteCredentialsException {
        RouteCredentials routeCredentials = this.routeCredentialsHandler.getCredentials(string);
        if (routeCredentials == null) {
            throw new NoRouteCredentialsException("no security credentials found for route ID: " + string);
        }
        return routeCredentials;
    }

    public void notifyMessageReception(String string, MessageRef messageRef) throws RemoteException, org.csapi.www.wsdl.parlayx.mm.v1_0.notification.ApplicationException {
        MmNotificationPortImpl mmNotificationPortImpl = this.retrieveNotificationPort(string);
        if (mmNotificationPortImpl != null) {
            mmNotificationPortImpl.notifyMessageReception(string, messageRef);
        } else {
            this.log.error((Object)("No registered message listener for Route ID: " + string));
        }
    }

    public void notifySmsReception(String string, String string2, EndUserIdentifier endUserIdentifier, String string3) throws RemoteException, ApplicationException {
        MmNotificationPortImpl mmNotificationPortImpl = this.retrieveNotificationPort(string);
        if (mmNotificationPortImpl != null) {
            MessageRef messageRef = new MessageRef(null, string2, endUserIdentifier, null, MessagePriority.Default, string3);
            mmNotificationPortImpl.notifyMessageReception(string, messageRef);
        } else {
            this.log.error((Object)("No registered message listener for Route ID: " + string));
        }
    }

    public void notifyLongSmsReception(String string, String string2, String string3, String string4, int n, int n2, int n3) throws RemoteException {
        throw new UnsupportedOperationException("Long SMS notification not supported by MessageManager");
    }

    private MmNotificationPortImpl retrieveNotificationPort(String string) {
        MmNotificationPortImpl mmNotificationPortImpl = (MmNotificationPortImpl)this.listeners.get(string);
        if (mmNotificationPortImpl == null) {
            mmNotificationPortImpl = (MmNotificationPortImpl)this.listeners.get(null);
        }
        return mmNotificationPortImpl;
    }

    public void setSendMessagePortURL(String string) throws MalformedURLException {
        this.sendMessagePortAddress = new URL(string);
    }

    public String getSendMessagePortURL() {
        return this.sendMessagePortAddress.toString();
    }

    public void setReceiveMessagePortURL(String string) throws MalformedURLException {
        this.receiveMessagePortAddress = new URL(string);
    }

    public String getReceiveMessagePortURL() {
        return this.receiveMessagePortAddress.toString();
    }

    public void setRouteCredentialsHandler(RouteCredentialsHandler routeCredentialsHandler) {
        this.routeCredentialsHandler = routeCredentialsHandler;
    }

    public RouteCredentialsHandler getRouteCredentialsHandler() {
        return this.routeCredentialsHandler;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }
}

