/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.message;

import hr.tis.mgw.client.GatewayException;
import hr.tis.mgw.client.charging.Charging;
import hr.tis.mgw.client.message.Attachment;
import hr.tis.mgw.client.message.Message;
import hr.tis.mgw.client.message.MessageId;
import hr.tis.mgw.client.message.MessageManager2;
import hr.tis.mgw.client.message.MmsPart;
import hr.tis.mgw.client.message.Priority;
import hr.tis.mgw.client.message.SendResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MmsMessage
extends Message {
    private String subject;
    private List parts;

    public MmsMessage() {
        this(null);
    }

    public MmsMessage(String string) {
        this(string, new ArrayList());
    }

    public MmsMessage(String string, List list) {
        this.subject = string;
        this.parts = list;
    }

    MessageId send(MessageManager2 messageManager2, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        return messageManager2.sendMms(this, stringArray, string, priority, charging, string2, string3);
    }

    SendResult sendWithResult(MessageManager2 messageManager2, String[] stringArray, String string, Priority priority, Charging charging, String string2, String string3) throws GatewayException {
        return messageManager2.sendMmsWithResult(this, stringArray, string, priority, charging, string2, string3);
    }

    public void addPart(MmsPart mmsPart) {
        this.parts.add(mmsPart);
    }

    public void removePart(MmsPart mmsPart) {
        this.parts.remove(mmsPart);
    }

    public List getParts() {
        return this.parts;
    }

    public void clearParts() {
        this.parts.clear();
    }

    public void addAttachment(Attachment attachment) {
        this.addPart(new MmsPart(attachment.getBytes(), attachment.getContentType(), attachment.getContentId(), attachment.getContentLocation()));
    }

    public Attachment[] getAttachments() {
        Attachment[] attachmentArray = new Attachment[this.parts.size()];
        int n = 0;
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            MmsPart mmsPart = (MmsPart)iterator.next();
            attachmentArray[n] = new Attachment(mmsPart.getBytes(), mmsPart.getContentType(), mmsPart.getContentId(), mmsPart.getContentLocation());
            ++n;
        }
        return attachmentArray;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MmsMessage {Subject: ").append(this.subject).append(", Parts: ");
        if (this.parts != null && this.parts.size() > 0) {
            Iterator iterator = this.parts.iterator();
            while (iterator.hasNext()) {
                MmsPart mmsPart = (MmsPart)iterator.next();
                stringBuffer.append(mmsPart);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        } else {
            stringBuffer.append("-- EMPTY --");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

