/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.message.notification;

import hr.tis.mgw.client.GatewayException;
import hr.tis.mgw.client.ParlayXConverter;
import hr.tis.mgw.client.message.Attachment;
import hr.tis.mgw.client.message.DeliveryStatusInfo;
import hr.tis.mgw.client.message.Message;
import hr.tis.mgw.client.message.MessageManager;
import hr.tis.mgw.client.message.MmsMessage;
import hr.tis.mgw.client.message.Priority;
import hr.tis.mgw.client.message.SmsMessage;
import hr.tis.mgw.client.message.Status;
import hr.tis.mgw.client.message.UnknownMessageIdentifierException;
import hr.tis.mgw.client.message.notification.MessageListener;
import hr.tis.mgw.client.security.NoRouteCredentialsException;
import java.rmi.RemoteException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.www.schema.parlayx.mm.v1_0.DeliveryStatus;
import org.csapi.www.schema.parlayx.mm.v1_0.MessageRef;
import org.csapi.www.wsdl.parlayx.mm.v1_0.notification.ApplicationException;
import org.csapi.www.wsdl.parlayx.mm.v1_0.notification.MmNotificationPort;

public class MmNotificationPortImpl
implements MmNotificationPort {
    private final Log log = LogFactory.getLog((Class)MmNotificationPortImpl.class);
    private final Pattern deliveryReportPattern = Pattern.compile("\\b(ID:\\S+)\\s+STAT:(\\S+)", 2);
    private MessageListener messageListener;
    private MessageManager messageManager;

    public void notifyMessageReception(String string, MessageRef messageRef) throws RemoteException, ApplicationException {
        this.checkDependencies();
        if (messageRef == null) {
            throw new IllegalArgumentException("MessageRef is null");
        }
        Priority priority = ParlayXConverter.fromParlayXMessagePriority(messageRef.getPriority());
        String string2 = messageRef.getMessageServiceActivationNumber();
        URI uRI = messageRef.getSenderAddress().getValue();
        String string3 = uRI.getPath();
        this.log.info((Object)("Received call on operation 'notifyMessageReception'(MmNotificationPort): source=" + string3 + " serviceAddress=" + string2 + " priority=" + messageRef.getPriority() + " messageRefID=" + messageRef.getMessageRefIdentifier() + " routeId=" + string));
        if (messageRef.getMessage() != null && messageRef.getMessage().length() > 0) {
            Matcher matcher = this.deliveryReportPattern.matcher(messageRef.getMessage());
            if (matcher.find()) {
                String string4 = matcher.group(1);
                String string5 = matcher.group(2);
                this.processDeliveryStatusReceipt(string4, string5, string3, string2, string);
            } else {
                this.processSmsReceipt(messageRef, string3, string2, priority, string);
            }
        } else {
            this.processMmsReceipt(messageRef, string3, string2, priority, string);
        }
    }

    private void processDeliveryStatusReceipt(final String string, String string2, String string3, final String string4, final String string5) {
        DeliveryStatus deliveryStatus = DeliveryStatus.fromString(string2);
        Status status = ParlayXConverter.fromParlayXDeliveryStatus(deliveryStatus);
        final DeliveryStatusInfo deliveryStatusInfo = new DeliveryStatusInfo(string3, status);
        this.log.info((Object)("Delivery report received: messageId=" + string + " deliveryStatus=" + deliveryStatusInfo + " serviceAddress=" + string4 + " routeId=" + string5));
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    MmNotificationPortImpl.this.messageListener.deliveryStatusReceived(string, deliveryStatusInfo, string4, string5);
                }
                catch (Throwable throwable) {
                    MmNotificationPortImpl.this.log.error((Object)"error while notifying listener about received delivery status", throwable);
                }
            }
        };
        new Thread(runnable).start();
    }

    private void processSmsReceipt(MessageRef messageRef, final String string, final String string2, final Priority priority, final String string3) {
        final SmsMessage smsMessage = new SmsMessage(messageRef.getMessage());
        this.logMessageReceipt(smsMessage, string, string2, priority, string3);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    MmNotificationPortImpl.this.messageListener.smsReceived(smsMessage, string, string2, priority, string3);
                }
                catch (Throwable throwable) {
                    MmNotificationPortImpl.this.log.error((Object)"error while notifying listener about received SMS", throwable);
                }
            }
        };
        new Thread(runnable).start();
    }

    private void processMmsReceipt(MessageRef messageRef, final String string, final String string2, final Priority priority, final String string3) throws ApplicationException {
        try {
            Object object;
            final MmsMessage mmsMessage = new MmsMessage(messageRef.getSubject());
            this.log.info((Object)("Ref:" + messageRef.getMessageRefIdentifier() + ", Sender:" + messageRef.getSenderAddress() + ", Orig:" + messageRef.getMessageServiceActivationNumber() + ", Priority:" + messageRef.getPriority().getValue() + ", Message:" + messageRef.getMessage()));
            try {
                object = this.messageManager.getMessageAttachments(string3, messageRef.getMessageRefIdentifier());
                for (int i = 0; i < ((Attachment[])object).length; ++i) {
                    mmsMessage.addAttachment(object[i]);
                }
            }
            catch (NoRouteCredentialsException noRouteCredentialsException) {
                this.log.warn((Object)noRouteCredentialsException.getMessage());
            }
            this.logMessageReceipt(mmsMessage, string, string2, priority, string3);
            object = new Runnable(){

                public void run() {
                    try {
                        MmNotificationPortImpl.this.messageListener.mmsReceived(mmsMessage, string, string2, priority, string3);
                    }
                    catch (Throwable throwable) {
                        MmNotificationPortImpl.this.log.error((Object)"error while notifying listener about received MMS", throwable);
                    }
                }
            };
            new Thread((Runnable)object).start();
        }
        catch (GatewayException gatewayException) {
            throw new ApplicationException(gatewayException.getMessage());
        }
        catch (UnknownMessageIdentifierException unknownMessageIdentifierException) {
            throw new ApplicationException(unknownMessageIdentifierException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new ApplicationException(remoteException.getMessage());
        }
    }

    private void logMessageReceipt(Message message, String string, String string2, Priority priority, String string3) {
        StringBuffer stringBuffer = new StringBuffer("Message received:");
        stringBuffer.append(" message=").append(message);
        stringBuffer.append(" endUserAddress=").append(string);
        stringBuffer.append(" serviceAddress=").append(string2);
        stringBuffer.append(" priority=").append(priority);
        stringBuffer.append(" routeId=").append(string3);
        this.log.info((Object)stringBuffer.toString());
    }

    private void checkDependencies() {
        if (this.messageManager == null) {
            throw new IllegalStateException("MessageManager has to be set");
        }
        if (this.messageListener == null) {
            throw new IllegalStateException("MessageListener has to be set");
        }
    }

    public void setMessageManager(MessageManager messageManager) {
        this.messageManager = messageManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }
}

