/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.message.wap;

import hr.tis.mgw.client.message.wap.InfoItem;
import hr.tis.mgw.client.message.wap.PushSIMessage;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

class SIDocumentGenerator {
    private static final Log log = LogFactory.getLog((Class)SIDocumentGenerator.class);

    private SIDocumentGenerator() {
    }

    public static String buildDocumentXML(PushSIMessage pushSIMessage) {
        Element element;
        if (pushSIMessage == null) {
            throw new IllegalArgumentException("PushSIMessage is null");
        }
        log.info((Object)("Generating XML from SI (Service Indication) message: " + pushSIMessage));
        Element element2 = new Element("si");
        Element element3 = SIDocumentGenerator.createIndicationElement(pushSIMessage);
        element2.addContent((Content)element3);
        InfoItem[] infoItemArray = pushSIMessage.getInfoItems();
        if (infoItemArray != null && infoItemArray.length > 0) {
            element = SIDocumentGenerator.createInfoElement(infoItemArray);
            element2.addContent((Content)element);
        }
        element = new DocType("si", "-//WAPFORUM//DTD SI 1.0//EN", "http://www.wapforum.org/DTD/si.dtd");
        Document document = new Document(element2, (DocType)element);
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        String string = xMLOutputter.outputString(document).trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed SI XML document:\n" + string));
        }
        return string;
    }

    private static Element createIndicationElement(PushSIMessage pushSIMessage) {
        Element element = new Element("indication");
        if (pushSIMessage.getURI() != null) {
            element.setAttribute("href", pushSIMessage.getURI().toString());
        }
        if (pushSIMessage.getId() != null) {
            element.setAttribute("si-id", pushSIMessage.getId());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (pushSIMessage.getCreationTime() != null) {
            element.setAttribute("created", simpleDateFormat.format(pushSIMessage.getCreationTime()));
        }
        if (pushSIMessage.getExpirationTime() != null) {
            element.setAttribute("si-expires", simpleDateFormat.format(pushSIMessage.getExpirationTime()));
        }
        if (pushSIMessage.getAction() != null) {
            element.setAttribute("action", pushSIMessage.getAction().toString());
        }
        if (pushSIMessage.getText() != null) {
            element.setText(pushSIMessage.getText());
        }
        return element;
    }

    private static Element createInfoElement(InfoItem[] infoItemArray) {
        Element element = new Element("info");
        for (int i = 0; i < infoItemArray.length; ++i) {
            Element element2 = new Element("item");
            element2.setAttribute("class", infoItemArray[i].getValueClass());
            element2.setText(infoItemArray[i].getValue());
            element.addContent((Content)element2);
        }
        return element;
    }
}

