/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mime;

import hr.tis.mime.MimeContentType;
import hr.tis.mime.MimeHeader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MimeBodyPart {
    protected byte[] myBody;
    protected MimeContentType myContentType;
    private final List myHeaders = new LinkedList();

    public MimeBodyPart() {
    }

    public MimeBodyPart(byte[] body, MimeContentType contentType) {
        this();
        this.setContent(body, contentType);
    }

    public MimeBodyPart(byte[] body, String contentType) {
        this();
        this.setContent(body, contentType);
    }

    public void addHeader(MimeHeader theHeader) {
        this.myHeaders.add(theHeader);
    }

    public void addHeader(String theHeaderName, String theHeaderValue) {
        MimeHeader header = this.getHeader(theHeaderName);
        if (header != null) {
            this.myHeaders.remove(header);
            header = null;
        }
        this.addHeader(new MimeHeader(theHeaderName, theHeaderValue));
    }

    public MimeHeader getHeader(int theIndex) {
        return (MimeHeader)this.myHeaders.get(theIndex);
    }

    public MimeHeader getHeader(String headerName) {
        Iterator iter = this.myHeaders.iterator();
        while (iter.hasNext()) {
            MimeHeader header = (MimeHeader)iter.next();
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            return header;
        }
        return null;
    }

    public int getHeaderCount() {
        return this.myHeaders.size();
    }

    public void setContent(byte[] theContent, String theContentType) {
        this.setContent(theContent, new MimeContentType(theContentType));
    }

    public void setContent(byte[] theContent, MimeContentType theContentType) {
        this.myBody = new byte[theContent.length];
        System.arraycopy(theContent, 0, this.myBody, 0, theContent.length);
        this.myContentType = theContentType;
    }

    public byte[] getBody() {
        byte[] bodyCopy = null;
        if (this.myBody != null) {
            bodyCopy = new byte[this.myBody.length];
            System.arraycopy(this.myBody, 0, bodyCopy, 0, this.myBody.length);
        }
        return bodyCopy;
    }

    public MimeContentType getContentType() {
        return this.myContentType;
    }
}

