/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mime;

import hr.tis.mime.MimeHeaderParam;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MimeHeader {
    private final String myHeaderName;
    private final String myHeaderValue;
    private final List myParams;

    public MimeHeader(String theName, String theValue) {
        this.myHeaderName = theName;
        this.myHeaderValue = theValue;
        this.myParams = new LinkedList();
    }

    public String getName() {
        return this.myHeaderName;
    }

    public String getValue() {
        return this.myHeaderValue;
    }

    public void setParam(String theName, String theValue) {
        this.removeParam(theName);
        this.myParams.add(new MimeHeaderParam(theName, theValue));
    }

    public MimeHeaderParam getParam(String theName) {
        Iterator iter = this.myParams.iterator();
        while (iter.hasNext()) {
            MimeHeaderParam param = (MimeHeaderParam)iter.next();
            if (!param.getName().equalsIgnoreCase(theName)) continue;
            return param;
        }
        return null;
    }

    public void removeParam(String theName) {
        MimeHeaderParam param = this.getParam(theName);
        if (param != null) {
            this.myParams.remove(param);
        }
    }

    public List getAllParams() {
        return this.myParams;
    }

    public int getParamCount() {
        return this.myParams.size();
    }

    public MimeHeaderParam getParam(int theIndex) {
        return (MimeHeaderParam)this.myParams.get(theIndex);
    }

    public String toString() {
        String s = this.myHeaderName + "=" + this.myHeaderValue;
        Iterator i = this.myParams.iterator();
        while (i.hasNext()) {
            MimeHeaderParam mhp = (MimeHeaderParam)i.next();
            s = mhp.getName() + "=" + mhp.getValue();
        }
        return s;
    }
}

