/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.wap.wbxml;

import hr.tis.wap.StringUtil;
import hr.tis.wap.WspUtil;
import hr.tis.wap.wbxml.ApplicationTokensRegistry;
import hr.tis.wap.wbxml.CodePageState;
import hr.tis.wap.wbxml.GlobalTokens;
import hr.tis.wap.wbxml.NoOpEntityResolver;
import hr.tis.wap.wbxml.StringTable;
import hr.tis.wap.wbxml.tokens.AttrStartToken;
import hr.tis.wap.wbxml.tokens.AttrValueToken;
import hr.tis.wap.wbxml.tokens.OpaqueDataEncoder;
import hr.tis.wap.wbxml.tokens.TagToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public class WbxmlEncoder {
    public static final int WBXML_VERSION_1_0 = 0;
    public static final int WBXML_VERSION_1_1 = 1;
    public static final int WBXML_VERSION_1_2 = 2;
    public static final int WBXML_VERSION_1_3 = 3;
    private final Log log = LogFactory.getLog((Class)(class$hr$tis$wap$wbxml$WbxmlEncoder == null ? (class$hr$tis$wap$wbxml$WbxmlEncoder = WbxmlEncoder.class$("hr.tis.wap.wbxml.WbxmlEncoder")) : class$hr$tis$wap$wbxml$WbxmlEncoder));
    private static final EntityResolver NO_OP_ENTITY_RESOLVER = new NoOpEntityResolver();
    private final ApplicationTokensRegistry tokensRegistry;
    private final int wbxmlVersion;
    static /* synthetic */ Class class$hr$tis$wap$wbxml$WbxmlEncoder;

    public WbxmlEncoder(int wbxmlVersion, TagToken[] tagTokens, AttrStartToken[] attrStartTokens, AttrValueToken[] attrValueTokens) {
        this.tokensRegistry = new ApplicationTokensRegistry(tagTokens, attrStartTokens, attrValueTokens);
        this.wbxmlVersion = wbxmlVersion;
    }

    public byte[] encodeXML(String inputXml) {
        if (inputXml == null) {
            throw new IllegalArgumentException("input XML argument is null");
        }
        try {
            Document document = this.parseDocument(inputXml);
            if (!document.hasRootElement()) {
                throw new IllegalArgumentException("there's no root element in XML");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.encodeDocument(baos, document);
            byte[] outputBytes = baos.toByteArray();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("WBXML encoding output (" + outputBytes.length + " bytes): " + StringUtil.bytesToHexString(outputBytes)));
            }
            return outputBytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Document parseDocument(String xml) throws IOException {
        SAXBuilder builder = new SAXBuilder(false);
        builder.setEntityResolver(NO_OP_ENTITY_RESOLVER);
        try {
            return builder.build((Reader)new StringReader(xml));
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
    }

    private void encodeDocument(OutputStream os, Document document) throws IOException {
        ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
        CodePageState codePageState = new CodePageState();
        StringTable stringTable = new StringTable();
        this.encodeElement(bodyOutputStream, codePageState, stringTable, document.getRootElement());
        WspUtil.writeUint8(os, this.wbxmlVersion);
        String publicID = null;
        if (document.getDocType() != null) {
            publicID = document.getDocType().getPublicID();
        }
        this.writePublicId(os, publicID);
        WspUtil.writeUintvar(os, 106L);
        this.writeStringTable(os, stringTable);
        bodyOutputStream.writeTo(os);
    }

    private void encodeElement(OutputStream os, CodePageState codePageState, StringTable stringTable, Element element) throws IOException {
        boolean containsContent = !element.getContent().isEmpty();
        boolean containsAttributes = !element.getAttributes().isEmpty();
        TagToken tagToken = this.tokensRegistry.findTagToken(codePageState, element.getName());
        int tagCode = 0;
        if (tagToken == null) {
            tagCode = 4;
        } else {
            int codePage = tagToken.getCodePage();
            if (codePage != codePageState.getTagCodePage()) {
                codePageState.setTagCodePage(codePage);
                this.switchCodePage(os, codePage);
            }
            tagCode = tagToken.getCode();
        }
        if (containsContent && containsAttributes) {
            tagCode -= 64;
        } else if (containsContent) {
            tagCode += 64;
        } else if (containsAttributes) {
            tagCode -= 128;
        }
        os.write(tagCode);
        if (tagToken == null) {
            this.writeStringTableRefIndex(os, stringTable, element.getName());
        }
        if (containsAttributes) {
            Iterator iterator = element.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                this.encodeAttribute(os, codePageState, stringTable, attribute);
            }
            os.write(1);
        }
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            if (content instanceof Text) {
                String trimmedText = ((Text)content).getTextNormalize();
                if (trimmedText.equals("")) continue;
                if (tagToken != null && tagToken.getOpaqueDataEncoder() != null) {
                    this.writeOpaqueData(os, trimmedText, tagToken.getOpaqueDataEncoder());
                    continue;
                }
                this.writeInlineString(os, trimmedText);
                continue;
            }
            if (!(content instanceof Element)) continue;
            Element child = (Element)content;
            this.encodeElement(os, codePageState, stringTable, child);
        }
        if (containsContent) {
            os.write(1);
        }
    }

    private void encodeAttribute(OutputStream os, CodePageState codePageState, StringTable stringTable, Attribute attribute) throws IOException {
        AttrStartToken attrStartToken = this.tokensRegistry.findAttributeStartToken(codePageState, attribute.getName(), attribute.getValue());
        if (attrStartToken == null) {
            os.write(4);
            this.writeStringTableRefIndex(os, stringTable, attribute.getName());
        } else {
            int codePage = attrStartToken.getCodePage();
            if (codePage != codePageState.getAttributeCodePage()) {
                codePageState.setAttributeCodePage(codePage);
                this.switchCodePage(os, codePage);
            }
            os.write(attrStartToken.getCode());
        }
        if (attrStartToken != null && attrStartToken.getOpaqueDataEncoder() != null) {
            this.writeOpaqueData(os, attribute.getValue(), attrStartToken.getOpaqueDataEncoder());
        } else {
            String restOfValue = attrStartToken == null || attrStartToken.getValuePrefix() == null ? attribute.getValue() : attribute.getValue().substring(attrStartToken.getValuePrefix().length());
            this.encodeAttributeValue(os, codePageState, restOfValue);
        }
    }

    private void encodeAttributeValue(OutputStream os, CodePageState codePageState, String value) throws IOException {
        if (value.equals("")) {
            return;
        }
        AttrValueToken attrValueToken = this.tokensRegistry.findAttributeValueToken(value, codePageState);
        if (attrValueToken == null) {
            this.writeInlineString(os, value);
        } else {
            int attrValueTokenIndex = value.indexOf(attrValueToken.getValue());
            if (attrValueTokenIndex > 0) {
                this.writeInlineString(os, value.substring(0, attrValueTokenIndex));
            }
            os.write(attrValueToken.getCode());
            int restOfValueIndex = attrValueTokenIndex + attrValueToken.getValue().length();
            this.encodeAttributeValue(os, codePageState, value.substring(restOfValueIndex));
        }
    }

    private void writePublicId(OutputStream os, String publicId) throws IOException {
        Integer code;
        if (publicId != null && (code = (Integer)GlobalTokens.OMNA_WBXML_PUBLIC_DOCUMENT_IDS.get(publicId)) != null) {
            WspUtil.writeUintvar(os, code.intValue());
            return;
        }
        WspUtil.writeUintvar(os, 1L);
    }

    private void writeStringTable(OutputStream os, StringTable stringTable) throws IOException {
        byte[] bytes = stringTable.getBytes();
        WspUtil.writeUintvar(os, bytes.length);
        os.write(bytes);
    }

    private void writeStringTableRefIndex(OutputStream os, StringTable stringTable, String str) throws IOException {
        int referenceIndex = stringTable.getReferenceIndex(str);
        WspUtil.writeUintvar(os, referenceIndex);
    }

    private void writeInlineString(OutputStream os, String str) throws IOException {
        os.write(3);
        os.write(str.getBytes("UTF-8"));
        os.write(0);
    }

    private void writeOpaqueData(OutputStream os, String data, OpaqueDataEncoder opaqueDataEncoder) throws IOException {
        os.write(-61);
        byte[] bytes = opaqueDataEncoder.encode(data);
        WspUtil.writeUintvar(os, bytes.length);
        os.write(bytes);
    }

    private void switchCodePage(OutputStream os, int newCodePage) throws IOException {
        os.write(0);
        WspUtil.writeUint8(os, newCodePage);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

