/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.charging;

import hr.tis.mgw.client.GatewayException;
import hr.tis.mgw.client.ParlayXConverter;
import hr.tis.mgw.client.charging.Charging;
import hr.tis.mgw.client.charging.ChargingManager2;
import hr.tis.mgw.client.exceptions.AxisFaultUtility;
import hr.tis.mgw.client.exceptions.MRemoteException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.AmountChargingPort;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.AmountChargingService;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.AmountChargingServiceLocator;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.ReserveAmountChargingPort;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.ReserveAmountChargingService;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.ReserveAmountChargingServiceLocator;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.ReserveVolumeChargingPort;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.ReserveVolumeChargingService;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.ReserveVolumeChargingServiceLocator;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.VolumeChargingPort;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.VolumeChargingService;
import org.csapi.www.wsdl.parlayx.payment.v1_0.service.VolumeChargingServiceLocator;

public class ChargingManager2Impl
extends ChargingManager2 {
    private static final Log log = LogFactory.getLog((Class)ChargingManager2Impl.class);
    private URL amountChargingPortURL;
    private URL volumeChargingPortURL;
    private URL reserveAmountChargingPortURL;
    private URL reserveVolumeChargingPortURL;
    private AmountChargingService amountChargingService;
    private VolumeChargingService volumeChargingService;
    private ReserveAmountChargingService reserveAmountChargingService;
    private ReserveVolumeChargingService reserveVolumeChargingService;

    public ChargingManager2Impl() {
        this.initializeAxis();
    }

    public ChargingManager2Impl(String string) {
        this.setServerURL(string);
        this.initializeAxis();
    }

    public ChargingManager2Impl(String string, String string2, String string3) {
        this.validateCredentials(string2, string3);
        this.setUsername(string2);
        this.setPassword(string3);
        this.setServerURL(string);
        this.initializeAxis();
    }

    public void chargeAmount(String string, BigDecimal bigDecimal, String string2, String string3) throws GatewayException {
        this.chargeAmount(string, bigDecimal, string2, string3, this.username, this.password);
    }

    public void chargeAmount(String string, BigDecimal bigDecimal, String string2, String string3, String string4, String string5) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string4, string5);
        this.validateUser(string);
        this.validateAmount(bigDecimal);
        this.validateBillingText(string2);
        this.validateReferenceCode(string3);
        try {
            this.logDebugChargeRefundAmount("Charge Amount", string, bigDecimal, string2, string3, string4, string5);
            AmountChargingPort amountChargingPort = this.getAmountChargingPort(string4, string5);
            amountChargingPort.chargeAmount(ParlayXConverter.toEndUserIdentifier(string), bigDecimal, string2, string3);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    public void refundAmount(String string, BigDecimal bigDecimal, String string2, String string3) throws GatewayException {
        this.refundAmount(string, bigDecimal, string2, string3, this.username, this.password);
    }

    public void refundAmount(String string, BigDecimal bigDecimal, String string2, String string3, String string4, String string5) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string4, string5);
        this.validateUser(string);
        this.validateAmount(bigDecimal);
        this.validateBillingText(string2);
        this.validateReferenceCode(string3);
        try {
            this.logDebugChargeRefundAmount("Refund Amount", string, bigDecimal, string2, string3, string4, string5);
            AmountChargingPort amountChargingPort = this.getAmountChargingPort(string4, string5);
            amountChargingPort.refundAmount(ParlayXConverter.toEndUserIdentifier(string), bigDecimal, string2, string3);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    private void logDebugChargeRefundAmount(String string, String string2, BigDecimal bigDecimal, String string3, String string4, String string5, String string6) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" {User: ").append(string2);
            stringBuffer.append(", Amount: ").append(bigDecimal);
            stringBuffer.append(", Billing Text: ").append(string3);
            stringBuffer.append(", Reference Code: ").append(string4);
            stringBuffer.append(", Username: ").append(string5);
            stringBuffer.append(", Password: ").append(string6);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public void chargeVolume(String string, long l, String string2, String string3) throws GatewayException {
        this.chargeVolume(string, l, string2, string3, this.username, this.password);
    }

    public void chargeVolume(String string, long l, String string2, String string3, String string4, String string5) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string4, string5);
        this.validateUser(string);
        this.validateVolume(l);
        this.validateBillingText(string2);
        this.validateReferenceCode(string3);
        try {
            this.logDebugChargeRefundVolume("Charge Volume", string, l, string2, string3, string4, string5);
            VolumeChargingPort volumeChargingPort = this.getVolumeChargingPort(string4, string5);
            volumeChargingPort.chargeVolume(ParlayXConverter.toEndUserIdentifier(string), l, string2, string3);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    public void refundVolume(String string, long l, String string2, String string3) throws GatewayException {
        this.refundVolume(string, l, string2, string3, this.username, this.password);
    }

    public void refundVolume(String string, long l, String string2, String string3, String string4, String string5) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string4, string5);
        this.validateUser(string);
        this.validateVolume(l);
        this.validateBillingText(string2);
        this.validateReferenceCode(string3);
        try {
            this.logDebugChargeRefundVolume("Refund Volume", string, l, string2, string3, string4, string5);
            VolumeChargingPort volumeChargingPort = this.getVolumeChargingPort(string4, string5);
            volumeChargingPort.refundVolume(ParlayXConverter.toEndUserIdentifier(string), l, string2, string3);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    private void logDebugChargeRefundVolume(String string, String string2, long l, String string3, String string4, String string5, String string6) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" {User: ").append(string2);
            stringBuffer.append(", Volume: ").append(l);
            stringBuffer.append(", Billing Text: ").append(string3);
            stringBuffer.append(", Reference Code: ").append(string4);
            stringBuffer.append(", Username: ").append(string5);
            stringBuffer.append(", Password: ").append(string6);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public BigDecimal getAmount(String string, long l) throws GatewayException {
        return this.getAmount(string, l, this.username, this.password);
    }

    public BigDecimal getAmount(String string, long l, String string2, String string3) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string2, string3);
        this.validateUser(string);
        this.validateVolume(l);
        try {
            this.logDebugGetAmount(string, l, string2, string3);
            VolumeChargingPort volumeChargingPort = this.getVolumeChargingPort(string2, string3);
            return volumeChargingPort.getAmount(ParlayXConverter.toEndUserIdentifier(string), l);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    private void logDebugGetAmount(String string, long l, String string2, String string3) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Get Amount {User: ").append(string);
            stringBuffer.append(", Volume: ").append(l);
            stringBuffer.append(", Username: ").append(string2);
            stringBuffer.append(", Password: ").append(string3);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public Charging reserveAmount(String string, BigDecimal bigDecimal, String string2) throws GatewayException {
        return this.reserveAmount(string, bigDecimal, string2, this.username, this.password);
    }

    public Charging reserveAmount(String string, BigDecimal bigDecimal, String string2, String string3, String string4) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string3, string4);
        this.validateUser(string);
        this.validateAmount(bigDecimal);
        this.validateBillingText(string2);
        try {
            this.logDebugReserveAmount(string, bigDecimal, string2, string3, string4);
            ReserveAmountChargingPort reserveAmountChargingPort = this.getReserveAmountChargingPort(string3, string4);
            String string5 = reserveAmountChargingPort.reserveAmount(ParlayXConverter.toEndUserIdentifier(string), bigDecimal, string2);
            return new Charging(string5);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    private void logDebugReserveAmount(String string, BigDecimal bigDecimal, String string2, String string3, String string4) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Reserve Amount {User: ").append(string);
            stringBuffer.append(", Amount: ").append(bigDecimal);
            stringBuffer.append(", Billing Text: ").append(string2);
            stringBuffer.append(", Username: ").append(string3);
            stringBuffer.append(", Password: ").append(string4);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public void reserveAdditionalAmount(Charging charging, BigDecimal bigDecimal, String string) throws GatewayException {
        this.reserveAdditionalAmount(charging, bigDecimal, string, this.username, this.password);
    }

    public void reserveAdditionalAmount(Charging charging, BigDecimal bigDecimal, String string, String string2, String string3) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string2, string3);
        this.validateCharging(charging);
        this.validateAmount(bigDecimal);
        this.validateBillingText(string);
        try {
            this.logDebugReserveAdditionalAmount(charging, bigDecimal, string, string2, string3);
            ReserveAmountChargingPort reserveAmountChargingPort = this.getReserveAmountChargingPort(string2, string3);
            reserveAmountChargingPort.reserveAdditionalAmount(charging.getReservationId(), bigDecimal, string);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
    }

    private void logDebugReserveAdditionalAmount(Charging charging, BigDecimal bigDecimal, String string, String string2, String string3) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Reserve Additional Amount {").append(charging);
            stringBuffer.append(", Amount: ").append(bigDecimal);
            stringBuffer.append(", Billing Text: ").append(string);
            stringBuffer.append(", Username: ").append(string2);
            stringBuffer.append(", Password: ").append(string3);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public void chargeAmountReservation(Charging charging, BigDecimal bigDecimal, String string, String string2) throws GatewayException {
        this.chargeAmountReservation(charging, bigDecimal, string, string2, this.username, this.password);
    }

    public void chargeAmountReservation(Charging charging, BigDecimal bigDecimal, String string, String string2, String string3, String string4) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string3, string4);
        this.validateCharging(charging);
        this.validateAmount(bigDecimal);
        this.validateReferenceCode(string2);
        try {
            this.logDebugChargeAmountReservation(charging, bigDecimal, string, string2, string3, string4);
            ReserveAmountChargingPort reserveAmountChargingPort = this.getReserveAmountChargingPort(string3, string4);
            reserveAmountChargingPort.chargeReservation(charging.getReservationId(), bigDecimal, string, string2);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
    }

    private void logDebugChargeAmountReservation(Charging charging, BigDecimal bigDecimal, String string, String string2, String string3, String string4) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Charge Amount Reservation {").append(charging);
            stringBuffer.append(", Amount: ").append(bigDecimal);
            stringBuffer.append(", Billing Text: ").append(string != null ? string : "-- NOT SET --");
            stringBuffer.append(", Reference Code: ").append(string2);
            stringBuffer.append(", Username: ").append(string3);
            stringBuffer.append(", Password: ").append(string4);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public void releaseAmountReservation(Charging charging) throws GatewayException {
        this.releaseAmountReservation(charging, this.username, this.password);
    }

    public void releaseAmountReservation(Charging charging, String string, String string2) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string, string2);
        this.validateCharging(charging);
        try {
            this.logDebugReleaseAmountReservation(charging, string, string2);
            ReserveAmountChargingPort reserveAmountChargingPort = this.getReserveAmountChargingPort(string, string2);
            reserveAmountChargingPort.releaseReservation(charging.getReservationId());
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
    }

    private void logDebugReleaseAmountReservation(Charging charging, String string, String string2) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Release Amount Reservation {").append(charging);
            stringBuffer.append(", Username: ").append(string);
            stringBuffer.append(", Password: ").append(string2);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public Charging reserveVolume(String string, long l, String string2) throws GatewayException {
        return this.reserveVolume(string, l, string2, this.username, this.password);
    }

    public Charging reserveVolume(String string, long l, String string2, String string3, String string4) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string3, string4);
        this.validateUser(string);
        this.validateVolume(l);
        this.validateBillingText(string2);
        try {
            this.logDebugReserveVolume(string, l, string2, string3, string4);
            ReserveVolumeChargingPort reserveVolumeChargingPort = this.getReserveVolumeChargingPort(string3, string4);
            String string5 = reserveVolumeChargingPort.reserveVolume(ParlayXConverter.toEndUserIdentifier(string), l, string2);
            return new Charging(string5);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    private void logDebugReserveVolume(String string, long l, String string2, String string3, String string4) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Reserve Volume {User: ").append(string);
            stringBuffer.append(", Volume: ").append(l);
            stringBuffer.append(", Billing Text: ").append(string2);
            stringBuffer.append(", Username: ").append(string3);
            stringBuffer.append(", Password: ").append(string4);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public void reserveAdditionalVolume(Charging charging, long l, String string) throws GatewayException {
        this.reserveAdditionalVolume(charging, l, string, this.username, this.password);
    }

    public void reserveAdditionalVolume(Charging charging, long l, String string, String string2, String string3) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string2, string3);
        this.validateCharging(charging);
        this.validateVolume(l);
        this.validateBillingText(string);
        try {
            this.logDebugReserveAdditionalVolume(charging, l, string, string2, string3);
            ReserveVolumeChargingPort reserveVolumeChargingPort = this.getReserveVolumeChargingPort(string2, string3);
            reserveVolumeChargingPort.reserveAdditionalVolume(charging.getReservationId(), l, string);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
    }

    private void logDebugReserveAdditionalVolume(Charging charging, long l, String string, String string2, String string3) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Reserve Additional Volume {").append(charging);
            stringBuffer.append(", Volume: ").append(l);
            stringBuffer.append(", Billing Text: ").append(string);
            stringBuffer.append(", Username: ").append(string2);
            stringBuffer.append(", Password: ").append(string3);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public void chargeVolumeReservation(Charging charging, long l, String string, String string2) throws GatewayException {
        this.chargeVolumeReservation(charging, l, string, string2, this.username, this.password);
    }

    public void chargeVolumeReservation(Charging charging, long l, String string, String string2, String string3, String string4) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string3, string4);
        this.validateCharging(charging);
        this.validateVolume(l);
        this.validateReferenceCode(string2);
        try {
            this.logDebugChargeVolumeReservation(charging, l, string, string2, string3, string4);
            ReserveVolumeChargingPort reserveVolumeChargingPort = this.getReserveVolumeChargingPort(string3, string4);
            reserveVolumeChargingPort.chargeReservation(charging.getReservationId(), l, string, string2);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
    }

    private void logDebugChargeVolumeReservation(Charging charging, long l, String string, String string2, String string3, String string4) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Charge Volume Reservation {").append(charging);
            stringBuffer.append(", Volume ").append(l);
            stringBuffer.append(", Billing Text: ").append(string != null ? string : "-- NOT SET --");
            stringBuffer.append(", Reference Code: ").append(string2);
            stringBuffer.append(", Username: ").append(string3);
            stringBuffer.append(", Password: ").append(string4);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public void releaseVolumeReservation(Charging charging) throws GatewayException {
        this.releaseVolumeReservation(charging, this.username, this.password);
    }

    public void releaseVolumeReservation(Charging charging, String string, String string2) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string, string2);
        this.validateCharging(charging);
        try {
            this.logDebugReleaseVolumeReservation(charging, string, string2);
            ReserveVolumeChargingPort reserveVolumeChargingPort = this.getReserveVolumeChargingPort(string, string2);
            reserveVolumeChargingPort.releaseReservation(charging.getReservationId());
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
    }

    private void logDebugReleaseVolumeReservation(Charging charging, String string, String string2) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Release Volume Reservation {").append(charging);
            stringBuffer.append(", Username: ").append(string);
            stringBuffer.append(", Password: ").append(string2);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    public BigDecimal getReservationAmount(String string, long l) throws GatewayException {
        return this.getReservationAmount(string, l, this.username, this.password);
    }

    public BigDecimal getReservationAmount(String string, long l, String string2, String string3) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string2, string3);
        this.validateUser(string);
        this.validateVolume(l);
        try {
            this.logDebugGetReservationAmount(string, l, string2, string3);
            ReserveVolumeChargingPort reserveVolumeChargingPort = this.getReserveVolumeChargingPort(string2, string3);
            return reserveVolumeChargingPort.getAmount(ParlayXConverter.toEndUserIdentifier(string), l);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    private void logDebugGetReservationAmount(String string, long l, String string2, String string3) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Get Reservation Amount {User: ").append(string);
            stringBuffer.append(", Volume: ").append(l);
            stringBuffer.append(", Username: ").append(string2);
            stringBuffer.append(", Password: ").append(string3);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    private void validatePortsURLs() {
        if (this.amountChargingPortURL == null || this.volumeChargingPortURL == null || this.reserveAmountChargingPortURL == null || this.reserveVolumeChargingPortURL == null) {
            throw new IllegalStateException("ServerURL must be set.");
        }
    }

    protected void initPortsURLs() {
        try {
            this.amountChargingPortURL = new URL(this.serverURL + "AmountChargingPort");
            this.volumeChargingPortURL = new URL(this.serverURL + "VolumeChargingPort");
            this.reserveAmountChargingPortURL = new URL(this.serverURL + "ReserveAmountChargingPort");
            this.reserveVolumeChargingPortURL = new URL(this.serverURL + "ReserveVolumeChargingPort");
            log.info((Object)("ChargingManager2 initialized. URLs :: AmountChargingPort-> " + this.amountChargingPortURL + ", VolumeChargingPort-> " + this.volumeChargingPortURL + ", ReserveAmountChargingPort-> " + this.reserveAmountChargingPortURL + ", ReserveVolumeChargingPort-> " + this.reserveVolumeChargingPortURL));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Not valid ServerURL: " + this.serverURL);
        }
    }

    private AmountChargingPort getAmountChargingPort(String string, String string2) {
        try {
            AmountChargingPort amountChargingPort = this.amountChargingService.getAmountChargingPort(this.amountChargingPortURL);
            this.applyCredentialsToStub(string, string2, (Stub)amountChargingPort);
            this.applyTimeoutToStub((Stub)amountChargingPort);
            return amountChargingPort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate amount charging port.", serviceException);
        }
    }

    private VolumeChargingPort getVolumeChargingPort(String string, String string2) {
        try {
            VolumeChargingPort volumeChargingPort = this.volumeChargingService.getVolumeChargingPort(this.volumeChargingPortURL);
            this.applyCredentialsToStub(string, string2, (Stub)volumeChargingPort);
            this.applyTimeoutToStub((Stub)volumeChargingPort);
            return volumeChargingPort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate volume charging port.", serviceException);
        }
    }

    private ReserveAmountChargingPort getReserveAmountChargingPort(String string, String string2) {
        try {
            ReserveAmountChargingPort reserveAmountChargingPort = this.reserveAmountChargingService.getReserveAmountChargingPort(this.reserveAmountChargingPortURL);
            this.applyCredentialsToStub(string, string2, (Stub)reserveAmountChargingPort);
            this.applyTimeoutToStub((Stub)reserveAmountChargingPort);
            return reserveAmountChargingPort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate reserve amount charging port.", serviceException);
        }
    }

    private ReserveVolumeChargingPort getReserveVolumeChargingPort(String string, String string2) {
        try {
            ReserveVolumeChargingPort reserveVolumeChargingPort = this.reserveVolumeChargingService.getReserveVolumeChargingPort(this.reserveVolumeChargingPortURL);
            this.applyCredentialsToStub(string, string2, (Stub)reserveVolumeChargingPort);
            this.applyTimeoutToStub((Stub)reserveVolumeChargingPort);
            return reserveVolumeChargingPort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate reserve volume charging port.", serviceException);
        }
    }

    protected void initAxisServices() {
        this.amountChargingService = new AmountChargingServiceLocator();
        this.volumeChargingService = new VolumeChargingServiceLocator();
        this.reserveAmountChargingService = new ReserveAmountChargingServiceLocator();
        this.reserveVolumeChargingService = new ReserveVolumeChargingServiceLocator();
    }
}

