/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.location;

import hr.tis.mgw.client.GatewayException;
import hr.tis.mgw.client.ParlayXConverter;
import hr.tis.mgw.client.exceptions.AxisFaultUtility;
import hr.tis.mgw.client.exceptions.MRemoteException;
import hr.tis.mgw.client.location.Accuracy;
import hr.tis.mgw.client.location.Location;
import hr.tis.mgw.client.location.LocationManager2;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.www.schema.parlayx.terminal_location.v1_0.LocationInfo;
import org.csapi.www.wsdl.parlayx.terminal_location.v1_0.service.MobileTerminalLocationPort;
import org.csapi.www.wsdl.parlayx.terminal_location.v1_0.service.MobileTerminalLocationService;
import org.csapi.www.wsdl.parlayx.terminal_location.v1_0.service.MobileTerminalLocationServiceLocator;

public class LocationManager2Impl
extends LocationManager2 {
    private static final Log log = LogFactory.getLog((Class)LocationManager2Impl.class);
    private URL mobileTerminalLocationPortURL;
    private MobileTerminalLocationService mobileTerminalLocationService;

    public LocationManager2Impl() {
        this.initializeAxis();
    }

    public LocationManager2Impl(String string) {
        this.setServerURL(string);
        this.initializeAxis();
    }

    public LocationManager2Impl(String string, String string2, String string3) {
        this.validateCredentials(string2, string3);
        this.setUsername(string2);
        this.setPassword(string3);
        this.setServerURL(string);
        this.initializeAxis();
    }

    public Location getLocation(String string, String string2, Accuracy accuracy) throws GatewayException {
        return this.getLocation(string, string2, accuracy, this.username, this.password);
    }

    public Location getLocation(String string, String string2, Accuracy accuracy, String string3, String string4) throws GatewayException {
        this.validatePortsURLs();
        this.validateCredentials(string3, string4);
        this.validateUser(string);
        this.validateAccuracy(accuracy);
        try {
            this.logDebugGetLocation(string, string2, accuracy, string3, string4);
            MobileTerminalLocationPort mobileTerminalLocationPort = this.getMobileTerminalLocationPort(string3, string4);
            LocationInfo locationInfo = mobileTerminalLocationPort.getLocation(ParlayXConverter.toEndUserIdentifier(string), ParlayXConverter.toEndUserIdentifier(string2), ParlayXConverter.toParlayXLocationAccuracy(accuracy));
            return ParlayXConverter.fromParlayXLocationInfo(locationInfo);
        }
        catch (AxisFault axisFault) {
            throw AxisFaultUtility.convertAxisFaultException(axisFault);
        }
        catch (RemoteException remoteException) {
            throw new MRemoteException(remoteException);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new RuntimeException("Malformed URI", malformedURIException);
        }
    }

    private void logDebugGetLocation(String string, String string2, Accuracy accuracy, String string3, String string4) {
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Get Location {User: ").append(string);
            stringBuffer.append(", Requester: ").append(string2 != null ? string2 : "-- NOT SET --");
            stringBuffer.append(", ").append(accuracy);
            stringBuffer.append(", Username: ").append(string3);
            stringBuffer.append(", Password: ").append(string4);
            stringBuffer.append("}");
            log.debug((Object)stringBuffer.toString());
        }
    }

    private void validatePortsURLs() {
        if (this.mobileTerminalLocationPortURL == null) {
            throw new IllegalStateException("ServerURL must be set.");
        }
    }

    protected void initPortsURLs() {
        try {
            this.mobileTerminalLocationPortURL = new URL(this.serverURL + "MobileTerminalLocationPort");
            log.info((Object)("LocationManager2 initialized. URLs :: MobileTerminalLocationPort-> " + this.mobileTerminalLocationPortURL));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Not valid ServerURL: " + this.serverURL);
        }
    }

    private MobileTerminalLocationPort getMobileTerminalLocationPort(String string, String string2) {
        try {
            MobileTerminalLocationPort mobileTerminalLocationPort = this.mobileTerminalLocationService.getMobileTerminalLocationPort(this.mobileTerminalLocationPortURL);
            this.applyCredentialsToStub(string, string2, (Stub)mobileTerminalLocationPort);
            this.applyTimeoutToStub((Stub)mobileTerminalLocationPort);
            return mobileTerminalLocationPort;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException("Can't instantiate mobile terminal location port.", serviceException);
        }
    }

    protected void initAxisServices() {
        this.mobileTerminalLocationService = new MobileTerminalLocationServiceLocator();
    }
}

