/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.message.wap;

import hr.tis.ems.SAR;
import hr.tis.mgw.client.message.AbstractBinaryMessage;
import hr.tis.mgw.client.message.Attachment;
import hr.tis.mgw.client.message.wap.Action;
import hr.tis.mgw.client.message.wap.InfoItem;
import hr.tis.mgw.client.message.wap.SIDateTimeEncoder;
import hr.tis.mgw.client.message.wap.SIDocumentGenerator;
import hr.tis.mime.MimeBodyPart;
import hr.tis.mime.MimeContentType;
import hr.tis.wap.WspEncoder;
import hr.tis.wap.wbxml.WbxmlEncoder;
import hr.tis.wap.wbxml.tokens.AttrStartToken;
import hr.tis.wap.wbxml.tokens.AttrValueToken;
import hr.tis.wap.wbxml.tokens.OpaqueDataEncoder;
import hr.tis.wap.wbxml.tokens.TagToken;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class PushSIMessage
extends AbstractBinaryMessage {
    private static final String WAP_PUSH_CONTENT_TYPE = "application/vnd.kis.mgw.pushsi";
    private static final String SI_WBXML_CONTENT_TYPE = "application/vnd.wap.sic";
    private static final int PORT_WAP_WSP = 9200;
    private static final int PORT_WAP_PUSH = 2948;
    private static final OpaqueDataEncoder SI_DATETIME_ENCODER = new SIDateTimeEncoder();
    private static final TagToken[] SI_WBXML_TAG_TOKENS = new TagToken[]{new TagToken(0, 5, "si"), new TagToken(0, 6, "indication"), new TagToken(0, 7, "info"), new TagToken(0, 8, "item")};
    private static final AttrStartToken[] SI_WBXML_ATTR_START_TOKENS = new AttrStartToken[]{new AttrStartToken(0, 5, "action", "signal-none"), new AttrStartToken(0, 6, "action", "signal-low"), new AttrStartToken(0, 7, "action", "signal-medium"), new AttrStartToken(0, 8, "action", "signal-high"), new AttrStartToken(0, 9, "action", "delete"), new AttrStartToken(0, 10, "created", SI_DATETIME_ENCODER), new AttrStartToken(0, 11, "href"), new AttrStartToken(0, 12, "href", "http://"), new AttrStartToken(0, 13, "href", "http://www."), new AttrStartToken(0, 14, "href", "https://"), new AttrStartToken(0, 15, "href", "https://www."), new AttrStartToken(0, 16, "si-expires", SI_DATETIME_ENCODER), new AttrStartToken(0, 17, "si-id"), new AttrStartToken(0, 18, "class")};
    private static final AttrValueToken[] SI_WBXML_ATTR_VALUE_TOKENS = new AttrValueToken[]{new AttrValueToken(0, 133, ".com/"), new AttrValueToken(0, 134, ".edu/"), new AttrValueToken(0, 135, ".net/"), new AttrValueToken(0, 136, ".org/")};
    private static final WbxmlEncoder WBXML_ENCODER = new WbxmlEncoder(2, SI_WBXML_TAG_TOKENS, SI_WBXML_ATTR_START_TOKENS, SI_WBXML_ATTR_VALUE_TOKENS);
    private final String text;
    private final URI uri;
    private final String id;
    private final Date creationTime;
    private final Date expirationTime;
    private final Action action;
    private final InfoItem[] infoItems;
    private final List smsBytesList;
    private final Attachment[] attachments;
    private final String toString;

    public PushSIMessage(String string) {
        this(null, null, Action.DELETE, null, null, string, null);
    }

    public PushSIMessage(String string, URI uRI) {
        this(string, uRI, null, null, null, null, null);
    }

    public PushSIMessage(String string, URI uRI, Action action, Date date, Date date2, String string2, InfoItem[] infoItemArray) {
        if (uRI == null && action != Action.DELETE) {
            throw new IllegalArgumentException("URI argument has to be specified when action is not DELETE");
        }
        if (string2 == null && action == Action.DELETE) {
            throw new IllegalArgumentException("ID has to be specified in case of DELETE action");
        }
        this.text = string;
        this.uri = uRI;
        this.action = action;
        this.creationTime = date;
        this.expirationTime = date2;
        this.id = string2;
        this.infoItems = infoItemArray;
        String string3 = SIDocumentGenerator.buildDocumentXML(this);
        this.smsBytesList = this.encodeAsBinaryList(string3);
        this.attachments = new Attachment[this.smsBytesList.size()];
        for (int i = 0; i < this.smsBytesList.size(); ++i) {
            byte[] byArray = (byte[])this.smsBytesList.get(i);
            this.attachments[i] = new Attachment(byArray, "application/octet-stream");
        }
        String string4 = this.infoItems == null ? "" : Arrays.asList(this.infoItems).toString();
        this.toString = "PushSIMessage {Text: " + string + ", URI: " + uRI + ", ID: " + string2 + ", " + action + ", CreationTime: " + date + ", ExpirationTime: " + date2 + ", InfoItems: " + string4 + "}";
    }

    private List encodeAsBinaryList(String string) {
        byte[] byArray = WBXML_ENCODER.encodeXML(string);
        MimeContentType mimeContentType = new MimeContentType(SI_WBXML_CONTENT_TYPE);
        mimeContentType.setParam("charset", "utf-8");
        MimeBodyPart mimeBodyPart = new MimeBodyPart(byArray, mimeContentType);
        byte[] byArray2 = WspEncoder.encode((MimeBodyPart)mimeBodyPart, (int)6);
        return SAR.split((byte[])byArray2, (int)9200, (int)2948);
    }

    public Action getAction() {
        return this.action;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public String getId() {
        return this.id;
    }

    public InfoItem[] getInfoItems() {
        return this.infoItems;
    }

    public String getText() {
        return this.text;
    }

    public URI getURI() {
        return this.uri;
    }

    public List getBinaryAttachmentsList() {
        return this.smsBytesList;
    }

    public String getContentType() {
        return WAP_PUSH_CONTENT_TYPE;
    }

    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return this.toString;
    }
}

