/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.message;

import hr.tis.mgw.client.message.DeliveryReport;
import hr.tis.mgw.client.message.MmsMessage;
import hr.tis.mgw.client.message.MmsPart;
import hr.tis.mgw.client.message.ReceivedMms;
import hr.tis.mgw.client.message.ReceivedSms;
import hr.tis.mgw.client.message.Status;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageHelper {
    private static Pattern deliveryReportPattern = Pattern.compile("\\bID:(\\S+)\\s+STAT:(\\S+)", 2);

    public static boolean isDeliveryReport(ReceivedSms receivedSms) {
        String string = receivedSms.getSmsMessage().getText();
        if (string != null) {
            Matcher matcher = deliveryReportPattern.matcher(string);
            return matcher.matches();
        }
        return false;
    }

    public static boolean isDeliveryReport(ReceivedMms receivedMms) {
        MmsPart mmsPart;
        String string;
        List list;
        MmsMessage mmsMessage = receivedMms.getMmsMessage();
        if (!MessageHelper.isDefined(receivedMms.getRefId()) && !MessageHelper.isDefined(mmsMessage.getSubject()) && (list = mmsMessage.getParts()).size() == 1 && (string = (mmsPart = (MmsPart)list.get(0)).getContentType()) != null && string.startsWith("text/plain")) {
            try {
                String string2 = new String(mmsPart.getBytes(), "UTF-8");
                Matcher matcher = deliveryReportPattern.matcher(string2);
                return matcher.matches();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return false;
    }

    public static DeliveryReport createDeliveryReport(ReceivedSms receivedSms) {
        String string = receivedSms.getSmsMessage().getText();
        Matcher matcher = deliveryReportPattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            return new DeliveryReport(receivedSms.getSenderAddress(), receivedSms.getDestinationAddress(), string2, receivedSms.getRegistrationIdentifier(), Status.fromValue(string3));
        }
        return null;
    }

    public static DeliveryReport createDeliveryReport(ReceivedMms receivedMms) {
        MmsPart mmsPart;
        String string;
        List list;
        MmsMessage mmsMessage = receivedMms.getMmsMessage();
        if (!MessageHelper.isDefined(receivedMms.getRefId()) && !MessageHelper.isDefined(mmsMessage.getSubject()) && (list = mmsMessage.getParts()).size() == 1 && (string = (mmsPart = (MmsPart)list.get(0)).getContentType()) != null && string.startsWith("text/plain")) {
            try {
                String string2 = new String(mmsPart.getBytes(), "UTF-8");
                Matcher matcher = deliveryReportPattern.matcher(string2);
                if (matcher.matches()) {
                    String string3 = matcher.group(1);
                    String string4 = matcher.group(2);
                    return new DeliveryReport(receivedMms.getSenderAddress(), receivedMms.getDestinationAddress(), string3, receivedMms.getRegistrationIdentifier(), Status.fromValue(string4));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isDefined(String string) {
        return string != null && !"".equals(string);
    }
}

