/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.message;

import hr.tis.mgw.client.message.AbstractBinaryMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SmppMessage
extends AbstractBinaryMessage {
    private static final String SMPP_CONTENT_TYPE = "application/vnd.kis.mgw.smpp";
    private static final int PREVIEW_LENGTH = 32;
    private List parts;

    public SmppMessage() {
        this.parts = new ArrayList();
    }

    public SmppMessage(byte[] byArray) {
        this.parts = new ArrayList();
        this.addPart(byArray);
    }

    public SmppMessage(List list) {
        this.parts = list;
    }

    public void addPart(byte[] byArray) {
        this.parts.add(byArray);
    }

    public List getParts() {
        return this.parts;
    }

    public List getBinaryAttachmentsList() {
        return this.parts;
    }

    public String getContentType() {
        return SMPP_CONTENT_TYPE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{SmppMessage parts=").append(this.parts.size()).append(", ");
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.partToString((byte[])iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private String partToString(byte[] byArray) {
        int n = byArray.length > 32 ? 32 : byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i];
            if (n2 < 0) {
                n2 += 128;
            }
            stringBuffer2.append(Integer.toHexString(n2));
            if (i >= n - 1) continue;
            stringBuffer2.append("-");
        }
        stringBuffer.append("Part {Length: ").append(byArray.length);
        stringBuffer.append(", Hex-L").append(32).append(": ").append(stringBuffer2).append("}");
        return stringBuffer.toString();
    }
}

