/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.mgw.client.security;

import hr.tis.mgw.client.security.RouteCredentials;
import hr.tis.mgw.client.security.RouteCredentialsHandler;
import hr.tis.mgw.client.security.RouteCredentialsLoadingFailureException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipleRouteCredentialsHandler
implements RouteCredentialsHandler {
    private Log log = LogFactory.getLog((Class)MultipleRouteCredentialsHandler.class);
    protected Map credentialsMap;
    protected Properties credentialsProperties;
    protected MessageFormat credentialsFormat;

    public MultipleRouteCredentialsHandler() {
    }

    public MultipleRouteCredentialsHandler(Properties properties, String string) throws RouteCredentialsLoadingFailureException {
        this.setCredentialsProperties(properties);
        this.setCredentialsPattern(string);
        this.load();
    }

    public void setCredentialsProperties(Properties properties) {
        this.credentialsProperties = properties;
        this.credentialsMap = null;
    }

    public void setCredentialsPattern(String string) {
        this.credentialsFormat = new MessageFormat(string);
    }

    public RouteCredentials getCredentials(String string) throws RouteCredentialsLoadingFailureException {
        if (this.credentialsMap == null) {
            this.load();
        }
        return (RouteCredentials)this.credentialsMap.get(string);
    }

    public void load() throws RouteCredentialsLoadingFailureException {
        try {
            if (this.credentialsMap != null) {
                return;
            }
            this.credentialsMap = new HashMap(this.credentialsProperties.size());
            int n = 0;
            Enumeration<Object> enumeration = this.credentialsProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object[] objectArray = this.credentialsFormat.parse(this.credentialsProperties.getProperty(string));
                RouteCredentials routeCredentials = new RouteCredentials((String)objectArray[0], (String)objectArray[1]);
                this.credentialsMap.put(string, routeCredentials);
                ++n;
            }
            this.log.info((Object)("loading finished, loaded: " + n + " credential(s)"));
        }
        catch (ParseException parseException) {
            throw new RouteCredentialsLoadingFailureException(parseException);
        }
    }
}

