/*
 * Decompiled with CFR 0.152.
 */
package hr.tis.wap.wbxml;

import hr.tis.wap.wbxml.CodePageState;
import hr.tis.wap.wbxml.tokens.ApplicationToken;
import hr.tis.wap.wbxml.tokens.AttrStartToken;
import hr.tis.wap.wbxml.tokens.AttrValueToken;
import hr.tis.wap.wbxml.tokens.TagToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ApplicationTokensRegistry {
    private final Map tagCodePageMap;
    private final Map attrStartCodePageMap;
    private final Map attrValueCodePageMap;

    public ApplicationTokensRegistry(TagToken[] tagTokens, AttrStartToken[] attrStartTokens, AttrValueToken[] attrValueTokens) {
        if (tagTokens == null) {
            throw new IllegalArgumentException("tag tokens argument is null");
        }
        if (attrStartTokens == null) {
            throw new IllegalArgumentException("attribute start tokens argument is null");
        }
        if (attrValueTokens == null) {
            throw new IllegalArgumentException("attribute value tokens argument is null");
        }
        this.tagCodePageMap = this.constructCodePageMap(tagTokens);
        this.attrStartCodePageMap = this.constructCodePageMap(attrStartTokens);
        this.attrValueCodePageMap = this.constructCodePageMap(attrValueTokens);
    }

    private Map constructCodePageMap(ApplicationToken[] applicationTokens) {
        HashMap codePageMap = new HashMap();
        for (int i = 0; i < applicationTokens.length; ++i) {
            ApplicationToken applicationToken = applicationTokens[i];
            Integer codePage = new Integer(applicationToken.getCodePage());
            if (codePageMap.get(codePage) == null) {
                codePageMap.put(codePage, new HashMap());
            }
            Map tokensMap = (Map)codePageMap.get(codePage);
            tokensMap.put(applicationToken.getSearchKey(), applicationToken);
        }
        return codePageMap;
    }

    public TagToken findTagToken(CodePageState codePageState, String tagName) {
        List codePagesList = this.constructSortedListOfCodePages(codePageState.getTagCodePage(), this.tagCodePageMap);
        Iterator iterator = codePagesList.iterator();
        while (iterator.hasNext()) {
            Integer codePage = (Integer)iterator.next();
            Map tagTokensMap = (Map)this.tagCodePageMap.get(codePage);
            TagToken tagToken = (TagToken)tagTokensMap.get(tagName);
            if (tagToken == null) continue;
            return tagToken;
        }
        return null;
    }

    private List constructSortedListOfCodePages(int activeCodePage, Map codePageMap) {
        Integer activeCodePageInt;
        ArrayList codePagesList = new ArrayList(codePageMap.keySet());
        int indexOfActiveCodePage = codePagesList.indexOf(activeCodePageInt = new Integer(activeCodePage));
        if (indexOfActiveCodePage != -1) {
            Collections.swap(codePagesList, indexOfActiveCodePage, 0);
        }
        return codePagesList;
    }

    public AttrStartToken findAttributeStartToken(CodePageState codePageState, String attributeName, String attributeValue) {
        String nameEqualsValue = attributeName + '=' + attributeValue;
        List codePagesList = this.constructSortedListOfCodePages(codePageState.getAttributeCodePage(), this.attrStartCodePageMap);
        AttrStartToken match = null;
        Iterator iterator = codePagesList.iterator();
        while (iterator.hasNext()) {
            Integer codePage = (Integer)iterator.next();
            Map attrStartTokensMap = (Map)this.attrStartCodePageMap.get(codePage);
            Iterator iterTokens = attrStartTokensMap.entrySet().iterator();
            while (iterTokens.hasNext()) {
                Map.Entry entry = iterTokens.next();
                String searchKey = (String)entry.getKey();
                if (!nameEqualsValue.startsWith(searchKey) || !this.isSearchKeyLonger(searchKey, match)) continue;
                match = (AttrStartToken)entry.getValue();
            }
        }
        return match;
    }

    private boolean isSearchKeyLonger(String searchKey, AttrStartToken match) {
        return match == null || searchKey.length() > match.getSearchKey().length();
    }

    public AttrValueToken findAttributeValueToken(String value, CodePageState codePageState) {
        AttrValueToken match = null;
        Integer attributeCodePage = new Integer(codePageState.getAttributeCodePage());
        Map attrValueTokensMap = (Map)this.attrValueCodePageMap.get(attributeCodePage);
        if (attrValueTokensMap != null) {
            int matchIndex = Integer.MAX_VALUE;
            Iterator iterator = attrValueTokensMap.values().iterator();
            while (iterator.hasNext()) {
                AttrValueToken token = (AttrValueToken)iterator.next();
                int index = value.indexOf(token.getValue());
                if (index == -1 || index >= matchIndex) continue;
                matchIndex = index;
                match = token;
            }
        }
        return match;
    }
}

