package hr.tis.mgw.client.samples.notification;

import hr.tis.mgw.client.message.MessageManager2;
import hr.tis.mgw.client.message.MessageManager2Impl;
import hr.tis.mgw.client.message.notification.MessageListener2;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * Sample <code>ServletContextListener</code> which registers <code>MessageListenerSample</code> with
 * <code>MessageManager2Impl</code>. Registration is performed once on servlet context initialization.
 */
public class WebAppStartupSample implements ServletContextListener {

	public static final String MM2_URL = "mm2.service-url";
	public static final String MM2_USERNAME = "mm2.username";
	public static final String MM2_PASSWORD = "mm2.password";

	public MessageManager2 messageManager2;

	public void contextInitialized(ServletContextEvent servletContextEvent) {
		ServletContext context = servletContextEvent.getServletContext();
		String url = context.getInitParameter(MM2_URL);
		String username = context.getInitParameter(MM2_USERNAME);
		String password = context.getInitParameter(MM2_PASSWORD);

		System.out.println("----------------------------------------------------");
		System.out.println("Initialize MessageManager2 ->");
		System.out.println("  Url: " + url);
		System.out.println("  Username: " + username);
		System.out.println("  Password: " + password);
		System.out.println();

		// initialize MessageManager2
		initMessageManager2(url, password, username);

		// register message listener(s)
		registerMessageListener();

		System.out.println("MessageListener registered to MessageManager2.");
	}

	/*
	 * Initialize <code>MessageManager2</code>.
	 * This has to be done only once per application.
	 * <code>MessageManager2</code> is required to download MMS part from server.
	 * Server only send MMS basic information (subject, originator, ...).
	 * All parts (images, sounds, text, ...) have to be downloaded explicitly.
	 * After initialization same MessageManager2 can also be used to send multiple sms and mms messages.
	 */
	public void initMessageManager2(String url, String password, String username) {
		messageManager2 = new MessageManager2Impl(url, username, password);
	}

	/*
	 * Register MessageListener.
	 * One <code>MessageManager2</code> can register many listeners.
	 * Listener is registered with registration identifier.
	 *
	 * <p>When server send message (sms or mms) to client application it also send registration identifier.
	 * Registration identifier is server specific, depending on server configuration and internal structure.
	 * MessageListener registered and matched with Registration Identifier sent by server will be called.
	 * If match is not found default (registered with <code>MessageManager2.REG_ID_ANY</code>) <code>MessageListener2</code>
	 * will be called.
	 * If no match and no default message listener, message will be ignored silently.
	 */
	public void registerMessageListener() {
		// register listener for any registration identifiers
		MessageListener2 listener = new MessageListenerSample();
		messageManager2.registerMessageListener(MessageManager2.REG_ID_ANY, listener);
	}

	public void contextDestroyed(ServletContextEvent servletContextEvent) {
	}
}
