package hr.tis.mgw.client.samples.send;

import hr.tis.mgw.client.GatewayException;
import hr.tis.mgw.client.location.Accuracy;
import hr.tis.mgw.client.location.Location;
import hr.tis.mgw.client.location.LocationManager2;
import hr.tis.mgw.client.location.LocationManager2Impl;

import java.util.Properties;

public class LocationSamples extends AbstractSamples {

	public static final String LC1_USER = "lc1.user";
	public static final String LC1_REQUESTER = "lc1.requester";

	public LocationManager2 locationManager2;

	/*
	 * Initialize LocationManager2.
	 * This has to be done only once per application.
	 * After initialization LocationManager2 can be used for multiple location requests.
	 */
	public void initLocationManager2(String url, String username, String password) {
		locationManager2 = new LocationManager2Impl(url, username, password);
	}

	/*
	 * Requesting user location
	 */
	public void getLocation(Properties prop) {
		// ----------------------
		// Initialization (getting values for location request)
		// ----------------------
		String user = prop.getProperty(LC1_USER); // user to locate
		String requester = prop.getProperty(LC1_REQUESTER); // requester of user location
		Accuracy accuracy = Accuracy.MEDIUM; // accuracy of location - contant your Mobile Operator for available values

		System.out.println();
		System.out.println("----------------------------------------------------");
		System.out.println("Requesting Location ->");
		System.out.println("  User: " + user);
		System.out.println("  Requester: " + requester);
		System.out.println("  Accuracy: " + accuracy);
		System.out.println();

		// ----------------------
		// Here is the actual code required to get location of user
		// ----------------------
		try {
			Location location = locationManager2.getLocation(user, requester, accuracy);

			System.out.println("Requesting user location successful ->");
			System.out.println("  " + location);
		}
		catch (GatewayException e) {
			System.err.println("Exception while getting location ->");
			e.printStackTrace(System.err);
		}
	}

	/*
	 * Application START method.
	 */
	public static void main(String[] args) {
		LocationSamples samples = new LocationSamples();

		// read and show properties from configuration file
		Properties prop = samples.readAndShowProperties("conf/location_sample.conf", args);

		// properties for samples
		String url = prop.getProperty(LM2_URL);
		String username = prop.getProperty(LM2_USERNAME);
		String password = prop.getProperty(LM2_PASSWORD);

		// initialize LocationManager2
		samples.initLocationManager2(url, username, password);

		// get location - example 1
		if (RUN_EXAMPLE.equalsIgnoreCase(prop.getProperty(EXAMPLE_1))) {
			samples.getLocation(prop);
		}
	}
}
